/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block.container;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.container.Status;

public class BlockContainer
implements Committable {
    private final Map<Long, Block> blocks = new HashMap<Long, Block>();
    private final int containerId;
    private final Media media;
    private Status status;

    public boolean hasBlock(long blockIndex) {
        return this.blocks.containsKey(blockIndex);
    }

    public Media getMedia() {
        return this.media;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public BlockContainer(Media media, int containerId) {
        this.containerId = containerId;
        this.media = media;
        this.status = Status.OPENED;
    }

    public int size() {
        return this.blocks.size();
    }

    public Block getBlock(long index, BlockType blockType) {
        this.checkOpened();
        Block block = this.blocks.get(index);
        if (block == null) {
            block = this.media.getMappedPhysicalBlocks().get(this, index, blockType);
            this.blocks.put(index, block);
        }
        return block;
    }

    public void evict(Block block) {
        this.checkOpened();
        if (!this.blocks.containsKey(block.getAbsoluteIndex())) {
            throw new RoStoreException("Can't evict unloaded block " + block.getAbsoluteIndex());
        }
        this.blocks.remove(block.getAbsoluteIndex());
        this.media.getMappedPhysicalBlocks().remove(this, block.getAbsoluteIndex());
    }

    public void evictIfLoaded(long blockIndex) {
        this.checkOpened();
        Block block = this.blocks.remove(blockIndex);
        if (block != null) {
            this.media.getMappedPhysicalBlocks().remove(this, block.getAbsoluteIndex());
        }
    }

    @Override
    public void close() {
        this.checkOpened();
        this.commit();
        this.status = Status.CLOSED;
        this.media.freeBlockContainer(this.containerId);
    }

    @Override
    public void commit() {
        this.checkOpened();
        Collection<Block> current;
        while (!(current = this.blocks.values()).isEmpty()) {
            current.iterator().next().close();
        }
        return;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }
}

