/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block.allocator;

import org.rostore.entity.BlockAllocation;
import org.rostore.entity.BlockAllocationState;
import org.rostore.entity.QuotaExceededException;
import org.rostore.v2.catalog.CachedCatalogBlockOperations;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.catalog.CatalogBlockOperations;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.InternalBlockProvider;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.allocator.BlockAllocatorInternal;
import org.rostore.v2.media.block.allocator.BlockAllocatorListeners;
import org.rostore.v2.media.block.container.Status;

public class SecondaryBlockAllocator {
    public static BlockAllocator create(String allocatorName, BlockAllocator rootBlockAllocator, long upperBlockNumberLimit) {
        CatalogBlockIndices catalogBlockIndices = rootBlockAllocator.allocate(BlockType.CATALOG, 4);
        InternalBlockProvider secondaryBlockProvider = InternalBlockProvider.create(rootBlockAllocator);
        CatalogBlockOperations reservedBlocksOperations = CatalogBlockOperations.create(secondaryBlockProvider, catalogBlockIndices);
        BlockAllocator secondaryBlockAllocator = SecondaryBlockAllocator.createSecondaryBlockAllocator(allocatorName, rootBlockAllocator, reservedBlocksOperations, upperBlockNumberLimit);
        secondaryBlockProvider.exchangeBlockAllocator(secondaryBlockAllocator);
        reservedBlocksOperations.add(catalogBlockIndices, true);
        reservedBlocksOperations.commit();
        if (reservedBlocksOperations.getBlockProvider().getMedia().getBlockAllocatorListeners().isEnabled()) {
            reservedBlocksOperations.getBlockProvider().getMedia().getBlockAllocatorListeners().notifyAllocated(allocatorName, BlockType.CATALOG, catalogBlockIndices, true);
        }
        return secondaryBlockAllocator;
    }

    public static BlockAllocator load(String allocatorName, BlockAllocator rootBlockAllocator, long startIndex, long upperBlockNumberLimit) {
        InternalBlockProvider secondaryBlockProvider = InternalBlockProvider.create(rootBlockAllocator);
        CatalogBlockOperations reservedBlocksOperations = CatalogBlockOperations.load(secondaryBlockProvider, startIndex);
        BlockAllocator secondaryBlockAllocator = SecondaryBlockAllocator.createSecondaryBlockAllocator(allocatorName, rootBlockAllocator, reservedBlocksOperations, upperBlockNumberLimit);
        secondaryBlockProvider.exchangeBlockAllocator(secondaryBlockAllocator);
        return secondaryBlockAllocator;
    }

    private static BlockAllocator createSecondaryBlockAllocator(final String name, final BlockAllocator rootBlockAllocator, final CatalogBlockOperations _reservedBlocksOperations, final long upperBlockNumberLimit) {
        final BlockAllocatorListeners blockAllocatorListeners = _reservedBlocksOperations.getBlockProvider().getMedia().getBlockAllocatorListeners();
        return BlockAllocator.wrap(new BlockAllocatorInternal(){
            private CachedCatalogBlockOperations reservedBlocksOperations;
            {
                this.reservedBlocksOperations = new CachedCatalogBlockOperations(_reservedBlocksOperations, 0, 50);
            }

            @Override
            public BlockAllocation getBlockAllocation() {
                long payloadBlocks = this.reservedBlocksOperations.getAddedNumber() * (long)this.getMedia().getMediaProperties().getBlockSize();
                long lockedFreeBlocks = this.reservedBlocksOperations.getCachedBlockNumber() * (long)this.getMedia().getMediaProperties().getBlockSize();
                return BlockAllocationState.init(0L, lockedFreeBlocks, payloadBlocks);
            }

            @Override
            public synchronized long getStartIndex() {
                return this.reservedBlocksOperations.getStartIndex();
            }

            @Override
            public Media getMedia() {
                return rootBlockAllocator.getMedia();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public synchronized long getFreeBlocks() {
                this.checkOpened();
                if (upperBlockNumberLimit == 0L) {
                    return rootBlockAllocator.getFreeBlocks();
                }
                return upperBlockNumberLimit - (this.reservedBlocksOperations.getAddedNumber() + this.reservedBlocksOperations.getSequenceIndexFreeBlockNumber() + this.reservedBlocksOperations.getCachedBlockNumber());
            }

            @Override
            public synchronized CatalogBlockIndices allocate(BlockType blockType, int blockNumber, boolean rebalance) {
                this.checkOpened();
                this.checkFree(this, blockNumber);
                CatalogBlockIndices allocated = rootBlockAllocator.getBlockAllocatorInternal().allocate(blockType, blockNumber, rebalance);
                this.reservedBlocksOperations.add(allocated, rebalance);
                this.reservedBlocksOperations.commit();
                if (blockAllocatorListeners.isEnabled()) {
                    blockAllocatorListeners.notifyAllocated(this.getName(), blockType, allocated, rebalance);
                }
                return allocated;
            }

            @Override
            public synchronized long allocate(BlockType blockType, boolean rebalance) {
                this.checkOpened();
                this.checkFree(this, 1L);
                long allocated = rootBlockAllocator.getBlockAllocatorInternal().allocate(blockType, rebalance);
                CatalogBlockIndices indices = new CatalogBlockIndices();
                indices.add(allocated, allocated);
                this.reservedBlocksOperations.add(indices, rebalance);
                this.reservedBlocksOperations.commit();
                if (blockAllocatorListeners.isEnabled()) {
                    blockAllocatorListeners.notifyAllocated(this.getName(), blockType, indices, rebalance);
                }
                return allocated;
            }

            @Override
            public synchronized void free(long blockIndex, boolean rebalance) {
                CatalogBlockIndices catalogBlockIndices = new CatalogBlockIndices();
                catalogBlockIndices.add(blockIndex, blockIndex);
                this.free(catalogBlockIndices, rebalance);
            }

            @Override
            public synchronized void free(CatalogBlockIndices indices, boolean rebalance) {
                this.checkOpened();
                this.reservedBlocksOperations.remove(indices, rebalance);
                this.reservedBlocksOperations.commit();
                rootBlockAllocator.getBlockAllocatorInternal().free(indices, rebalance);
                if (blockAllocatorListeners.isEnabled()) {
                    blockAllocatorListeners.notifyFreed(this.getName(), indices, rebalance);
                }
            }

            @Override
            public void dump() {
                System.out.println("Root:");
                rootBlockAllocator.getBlockAllocatorInternal().dump();
                System.out.println("Reserved:");
                this.reservedBlocksOperations.dump();
            }

            private void checkFree(BlockAllocatorInternal blockAllocator, long requested) {
                long tolerance = 5L;
                if (blockAllocator.getFreeBlocks() - 5L < requested) {
                    throw new QuotaExceededException("Can't allocate " + requested + " blocks. No enough free blocks (" + blockAllocator.getFreeBlocks() + "-5).");
                }
            }

            @Override
            public synchronized void close() {
                this.checkOpened();
                this.reservedBlocksOperations.close();
                this.reservedBlocksOperations.getBlockProvider().getBlockContainer().close();
            }

            @Override
            public Status getStatus() {
                return this.reservedBlocksOperations.getStatus();
            }

            @Override
            public synchronized void remove() {
                this.reservedBlocksOperations.iterateAll(catalogBlockIndices -> {
                    if (blockAllocatorListeners.isEnabled()) {
                        blockAllocatorListeners.notifyFreed(name, (CatalogBlockIndices)catalogBlockIndices, true);
                    }
                    rootBlockAllocator.free((CatalogBlockIndices)catalogBlockIndices);
                });
                this.reservedBlocksOperations.getBlockProvider().getBlockContainer().close();
            }
        });
    }
}

