/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block.allocator;

import org.rostore.entity.BlockAllocation;
import org.rostore.entity.BlockAllocationState;
import org.rostore.entity.QuotaExceededException;
import org.rostore.v2.catalog.CachedCatalogBlockOperations;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.catalog.CatalogBlockOperations;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.InternalBlockProvider;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.allocator.BlockAllocatorInternal;
import org.rostore.v2.media.block.allocator.BlockAllocatorListeners;
import org.rostore.v2.media.block.container.Status;

public class RootBlockAllocator {
    private static void checkFree(BlockAllocatorInternal blockAllocator, long requested) {
        long tolerance = 10L;
        if (blockAllocator.getFreeBlocks() - tolerance < requested) {
            throw new QuotaExceededException("Can't allocate " + requested + " blocks. No enough free blocks (" + blockAllocator.getFreeBlocks() + "-" + tolerance + ").");
        }
    }

    public static BlockAllocator create(Media media) {
        InternalBlockProvider blockProvider = InternalBlockProvider.create(media);
        CatalogBlockIndices catalogBlockIndices = new CatalogBlockIndices();
        catalogBlockIndices.add(1L, 4L);
        CatalogBlockOperations rootFreeBlockOperations = CatalogBlockOperations.create(blockProvider, catalogBlockIndices);
        rootFreeBlockOperations.add(5L, media.getMediaProperties().getTotalBlockNumber() - 1L, false);
        BlockAllocator rootBlockAllocator = RootBlockAllocator.createRootBlockAllocator(rootFreeBlockOperations);
        blockProvider.exchangeBlockAllocator(rootBlockAllocator);
        return rootBlockAllocator;
    }

    public static BlockAllocator load(Media media) {
        InternalBlockProvider blockProvider = InternalBlockProvider.create(media);
        BlockAllocator rootBlockAllocator = RootBlockAllocator.createRootBlockAllocator(CatalogBlockOperations.load(blockProvider, 1L));
        blockProvider.exchangeBlockAllocator(rootBlockAllocator);
        return rootBlockAllocator;
    }

    private static BlockAllocator createRootBlockAllocator(final CatalogBlockOperations _rootFreeBlockOperations) {
        final BlockAllocatorListeners blockAllocatorListeners = _rootFreeBlockOperations.getBlockProvider().getMedia().getBlockAllocatorListeners();
        return BlockAllocator.wrap(new BlockAllocatorInternal(){
            private CachedCatalogBlockOperations rootFreeBlockOperations;
            {
                this.rootFreeBlockOperations = new CachedCatalogBlockOperations(_rootFreeBlockOperations, 10, 100);
            }

            @Override
            public BlockAllocation getBlockAllocation() {
                long freeSize = this.getFreeBlocks() * (long)this.getMedia().getMediaProperties().getBlockSize();
                long totalSize = this.getMedia().getMediaProperties().getMaxTotalSize();
                return BlockAllocationState.init(totalSize, freeSize, totalSize - freeSize);
            }

            @Override
            public synchronized long getFreeBlocks() {
                return this.rootFreeBlockOperations.getSequenceIndexFreeBlockNumber() + this.rootFreeBlockOperations.getAddedNumber() + this.rootFreeBlockOperations.getCachedBlockNumber();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized CatalogBlockIndices allocate(BlockType blockType, int blockNumber, boolean rebalance) {
                RootBlockAllocator.checkFree(this, blockNumber);
                CatalogBlockIndices ret = null;
                try {
                    CatalogBlockIndices catalogBlockIndices = ret = this.rootFreeBlockOperations.extractIndex(blockNumber, rebalance);
                    return catalogBlockIndices;
                }
                finally {
                    this.rootFreeBlockOperations.commit();
                    if (ret != null && blockAllocatorListeners != null && blockAllocatorListeners.isEnabled()) {
                        blockAllocatorListeners.notifyAllocated(this.getName(), blockType, ret, rebalance);
                    }
                }
            }

            @Override
            public synchronized long allocate(BlockType blockType, boolean rebalance) {
                return this.allocate(blockType, 1, rebalance).iterator().get();
            }

            @Override
            public synchronized void free(long blockIndex, boolean rebalance) {
                CatalogBlockIndices catalogBlockIndices = new CatalogBlockIndices();
                catalogBlockIndices.add(blockIndex, blockIndex);
                this.free(catalogBlockIndices, rebalance);
            }

            @Override
            public synchronized void free(CatalogBlockIndices indices, boolean rebalance) {
                try {
                    if (blockAllocatorListeners != null && blockAllocatorListeners.isEnabled()) {
                        blockAllocatorListeners.notifyFreed(this.getName(), indices, rebalance);
                    }
                    this.rootFreeBlockOperations.add(indices, rebalance);
                }
                finally {
                    this.rootFreeBlockOperations.commit();
                }
            }

            @Override
            public void dump() {
                this.rootFreeBlockOperations.dump();
            }

            @Override
            public synchronized void close() {
                this.rootFreeBlockOperations.close();
            }

            @Override
            public Status getStatus() {
                return this.rootFreeBlockOperations.getStatus();
            }

            @Override
            public synchronized void remove() {
            }

            @Override
            public synchronized long getStartIndex() {
                return this.rootFreeBlockOperations.getStartIndex();
            }

            @Override
            public Media getMedia() {
                return this.rootFreeBlockOperations.getMedia();
            }

            @Override
            public String getName() {
                return "root";
            }
        });
    }
}

