/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block;

import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.container.BlockContainer;

public class MappedPhysicalBlock {
    private MappedByteBuffer mappedByteBuffer;
    private final long index;
    private boolean dirty;
    private Map<Integer, Block> blocks;
    private long unusedSince;
    private BlockType blockType;

    public Set<Integer> getAllContainerIds() {
        return this.blocks.keySet();
    }

    public long getUnusedSince() {
        return this.unusedSince;
    }

    public synchronized boolean inUse() {
        return !this.blocks.isEmpty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getIndex() {
        return this.index;
    }

    public void flush() {
        if (this.dirty) {
            this.mappedByteBuffer.force();
            this.dirty = false;
        }
    }

    protected MappedPhysicalBlock(long index, BlockType blockType) {
        this.index = index;
        this.blockType = blockType;
        this.dirty = false;
        this.blocks = new HashMap<Integer, Block>();
    }

    protected synchronized void markAsUsed(BlockContainer blockContainer) {
        this.blocks.put(blockContainer.getContainerId(), null);
    }

    protected void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    protected synchronized Block get(BlockContainer blockContainer) {
        Block block;
        if (this.mappedByteBuffer == null) {
            this.mappedByteBuffer = blockContainer.getMedia().map(this.index);
        }
        if ((block = this.blocks.get(blockContainer.getContainerId())) == null) {
            block = new Block(this.mappedByteBuffer.duplicate(), this, blockContainer);
            this.blocks.put(blockContainer.getContainerId(), block);
        }
        return block;
    }

    protected void setDirty() {
        this.dirty = true;
    }

    protected synchronized void remove(BlockContainer blockContainer) {
        this.blocks.remove(blockContainer.getContainerId());
        if (!this.inUse()) {
            this.unusedSince = System.currentTimeMillis();
        }
    }

    protected boolean isEmpty() {
        return this.blocks.isEmpty();
    }
}

