/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.fixsize;

import org.rostore.entity.RoStoreException;

public abstract class ValidatingEntry {
    private int index;

    public abstract int getEntriesNumber();

    public int getIndex() {
        return this.index;
    }

    public boolean isFirst() {
        this.throwExceptionIfInvalid("isFirst");
        return this.index == 0;
    }

    public void invalidate() {
        this.index = -1;
    }

    public void validate() {
        if (this.index < 0 || this.index >= this.getEntriesNumber()) {
            this.invalidate();
        }
    }

    public String toString() {
        return "Entry" + (this.invalid() ? "(invalid)" : "") + ": idx " + this.index;
    }

    public boolean invalid() {
        return this.index == -1;
    }

    public boolean valid() {
        return this.index != -1;
    }

    public void moveTo(int index) {
        if (index >= 0 && index < this.getEntriesNumber()) {
            this.index = index;
        } else {
            this.invalidate();
        }
    }

    public void last() {
        this.moveTo(this.getEntriesNumber() - 1);
    }

    public void first() {
        this.moveTo(0);
    }

    public void previous() {
        this.moveTo(this.index - 1);
    }

    public void next() {
        this.moveTo(this.index + 1);
    }

    protected void throwExceptionIfInvalid(String message) {
        if (this.invalid()) {
            throw new RoStoreException("The <" + String.valueOf(this) + "> is invalid: " + message);
        }
    }
}

