/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container;

import org.rostore.entity.Record;
import org.rostore.v2.container.ContainerShard;
import org.rostore.v2.keys.KeyBlockOperations;
import org.rostore.v2.keys.KeyList;
import org.rostore.v2.keys.RecordLengths;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.block.container.Status;
import org.rostore.v2.seq.BlockSequence;

public class ContainerShardKeyOperations
implements Committable {
    private final ContainerShard containerShard;
    private final KeyBlockOperations keyBlockOperations;

    public ContainerShardKeyOperations(ContainerShard containerShard) {
        this.containerShard = containerShard;
        this.keyBlockOperations = KeyBlockOperations.load(containerShard.getShardAllocator(), containerShard.getDescriptor().getKeysStartIndex(), RecordLengths.standardRecordLengths(containerShard.getContainer().getContainerListOperations().getMedia().getMediaProperties()));
    }

    public BlockSequence getBlockSequence() {
        return this.keyBlockOperations.getBlockSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long putKey(byte[] key, Record record) {
        long maxTTL = this.containerShard.getContainer().getDescriptor().getContainerMeta().getMaxTTL();
        if (maxTTL != 0L && (record.getTtl() == 0L || record.getTtl() > maxTTL)) {
            record.ttl(maxTTL);
        }
        try {
            long l = this.keyBlockOperations.put(key, record);
            return l;
        }
        finally {
            this.keyBlockOperations.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyList listKeys(byte[] startWithKey, byte[] continuationKey, int maxNumber, int maxSize) {
        try {
            KeyList keyList = this.keyBlockOperations.list(startWithKey, continuationKey, maxNumber, maxSize);
            return keyList;
        }
        finally {
            this.keyBlockOperations.commit();
        }
    }

    public Record getKey(byte[] key) {
        try {
            Record record = this.keyBlockOperations.getRecord(key);
            return record;
        }
        finally {
            this.keyBlockOperations.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeKeyIfExpired(int keyBlockSequenceIndex) {
        try {
            long l = this.keyBlockOperations.removeIfExpired(keyBlockSequenceIndex);
            return l;
        }
        finally {
            this.keyBlockOperations.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(byte[] key, Record record) {
        try {
            boolean bl = this.keyBlockOperations.remove(key, record);
            return bl;
        }
        finally {
            this.keyBlockOperations.commit();
        }
    }

    public void dump() {
        System.out.println("--- keys ---");
        this.keyBlockOperations.dump();
    }

    @Override
    public void close() {
        this.keyBlockOperations.close();
    }

    @Override
    public Status getStatus() {
        return null;
    }

    @Override
    public void commit() {
        this.keyBlockOperations.commit();
    }
}

