/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import org.rostore.entity.BlockAllocation;
import org.rostore.entity.Record;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.container.Container;
import org.rostore.v2.container.ContainerShardDescriptor;
import org.rostore.v2.container.ContainerShardKeyOperations;
import org.rostore.v2.data.DataReader;
import org.rostore.v2.data.DataWriter;
import org.rostore.v2.keys.KeyBlockOperations;
import org.rostore.v2.keys.RecordLengths;
import org.rostore.v2.media.Closeable;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.container.Status;

public class ContainerShard
implements Closeable {
    private final Container container;
    private final int index;
    private final ContainerShardDescriptor descriptor;
    private BlockAllocator shardAllocator;
    private List<ContainerShardKeyOperations> used = new ArrayList<ContainerShardKeyOperations>();
    private Queue<ContainerShardKeyOperations> unused = new LinkedList<ContainerShardKeyOperations>();

    public BlockAllocator getShardAllocator() {
        return this.shardAllocator;
    }

    public ContainerShardDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getIndex() {
        return this.index;
    }

    public Container getContainer() {
        return this.container;
    }

    protected static ContainerShard open(Container container, int index, ContainerShardDescriptor containerShardDescriptor) {
        return new ContainerShard(container, index, containerShardDescriptor);
    }

    protected static ContainerShard create(Container container, int index) {
        return new ContainerShard(container, index);
    }

    private ContainerShard(Container container, int index, ContainerShardDescriptor descriptor) {
        this.container = container;
        this.index = index;
        this.descriptor = descriptor;
        this.shardAllocator = container.getContainerListOperations().getMedia().loadSecondaryBlockAllocator(this.shardAllocatorName(), descriptor.getAllocatorStartIndex(), this.maxBlockNumber());
    }

    private String shardAllocatorName() {
        return "secondary:" + this.container.getName();
    }

    private ContainerShard(Container container, int index) {
        this.index = index;
        this.container = container;
        this.shardAllocator = container.getContainerListOperations().getMedia().createSecondaryBlockAllocator(this.shardAllocatorName(), this.maxBlockNumber());
        try (KeyBlockOperations keyBlockOperations = KeyBlockOperations.create(this.shardAllocator, RecordLengths.standardRecordLengths(container.getContainerListOperations().getMedia().getMediaProperties()));){
            this.descriptor = new ContainerShardDescriptor(this.shardAllocator.getStartIndex(), keyBlockOperations.getStartIndex());
        }
    }

    public BlockAllocation getBlockAllocation() {
        return this.shardAllocator.getBlockAllocation();
    }

    public <T extends InputStream> long putValue(T data) {
        return DataWriter.fromInputStream(this.shardAllocator, data);
    }

    public <T extends OutputStream> void getValue(Record record, T outputStream) {
        DataReader.toOutputStream(this.shardAllocator.getMedia(), record.getId(), outputStream);
    }

    public void removeValue(long id) {
        try (DataReader dataReader = DataReader.open(this.shardAllocator, id);){
            dataReader.free();
        }
    }

    private long maxBlockNumber() {
        return this.container.getDescriptor().getContainerMeta().getMaxSize() / (long)this.container.getContainerListOperations().getMedia().getMediaProperties().getBlockSize();
    }

    public String toString() {
        return "Shard: index=" + this.index;
    }

    public void remove() {
        if (!this.used.isEmpty()) {
            throw new RoStoreException("Can't remove the shard as it is in use");
        }
        for (ContainerShardKeyOperations ops : this.unused) {
            ops.close();
        }
        this.shardAllocator.remove();
    }

    @Override
    public void close() {
        if (!this.used.isEmpty()) {
            throw new RoStoreException("Can't close the shard as it is in use");
        }
        try {
            for (ContainerShardKeyOperations ops : this.unused) {
                ops.close();
            }
        }
        finally {
            this.shardAllocator.close();
        }
    }

    @Override
    public Status getStatus() {
        return this.shardAllocator.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerShardKeyOperations poll() {
        ContainerShard containerShard = this;
        synchronized (containerShard) {
            if (!this.unused.isEmpty()) {
                ContainerShardKeyOperations ops = this.unused.poll();
                this.used.add(ops);
                return ops;
            }
        }
        ContainerShardKeyOperations ops = new ContainerShardKeyOperations(this);
        ContainerShard containerShard2 = this;
        synchronized (containerShard2) {
            this.used.add(ops);
            return ops;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(ContainerShardKeyOperations ops) {
        try {
            ops.commit();
        }
        finally {
            boolean close = true;
            ContainerShard containerShard = this;
            synchronized (containerShard) {
                this.used.remove(ops);
                if (this.unused.size() < this.container.getContainerListOperations().getContainerListHeader().getContainerListProperties().getMaxKeyOperationsPerShard()) {
                    this.unused.offer(ops);
                    close = false;
                }
            }
            if (close) {
                ops.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T keyFunction(Function<ContainerShardKeyOperations, T> keyFunction) {
        ContainerShardKeyOperations ops = this.poll();
        try {
            T t = keyFunction.apply(ops);
            return t;
        }
        finally {
            this.done(ops);
        }
    }
}

