/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.rostore.entity.BlockAllocation;
import org.rostore.entity.ContainerAlreadyExistsException;
import org.rostore.entity.Record;
import org.rostore.entity.RoStoreException;
import org.rostore.entity.media.ContainerListProperties;
import org.rostore.entity.media.ContainerMeta;
import org.rostore.entity.media.RecordOption;
import org.rostore.v2.container.Container;
import org.rostore.v2.container.ContainerDescriptor;
import org.rostore.v2.container.ContainerListHeader;
import org.rostore.v2.data.DataReader;
import org.rostore.v2.data.DataWriter;
import org.rostore.v2.keys.KeyBlockOperations;
import org.rostore.v2.keys.KeyList;
import org.rostore.v2.keys.RecordLengths;
import org.rostore.v2.media.Media;

public class ContainerListOperations
implements AutoCloseable {
    private final ContainerListHeader containerListHeader;
    private final KeyBlockOperations keyBlockOperations;
    private Map<String, Container> openedContainers = new HashMap<String, Container>();

    public ContainerListHeader getContainerListHeader() {
        return this.containerListHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeContainer(String containerName) {
        Container container = this.openedContainers.get(containerName);
        if (container != null) {
            ContainerListOperations containerListOperations = this;
            synchronized (containerListOperations) {
                container = this.openedContainers.get(containerName);
                if (container == null) {
                    throw new RoStoreException("Container " + containerName + " is not open.");
                }
                container.closeInternal();
                this.openedContainers.remove(containerName);
            }
        } else {
            throw new RoStoreException("Container " + containerName + " is not open.");
        }
    }

    @Override
    public void close() {
        for (Map.Entry<String, Container> entry : this.openedContainers.entrySet()) {
            entry.getValue().close();
        }
        this.openedContainers.clear();
    }

    public Container get(String containerName) {
        return this.getOrExecute(containerName, () -> {
            try {
                Record record = this.keyBlockOperations.getRecord(containerName.getBytes(StandardCharsets.UTF_8));
                if (record == null) {
                    Container container = null;
                    return container;
                }
                ContainerDescriptor containerDescriptor = DataReader.readObject(this.getMedia(), record.getId(), ContainerDescriptor.class);
                Container container = new Container(this, containerName, containerDescriptor);
                return container;
            }
            finally {
                this.keyBlockOperations.commit();
            }
        }, null);
    }

    public synchronized BlockAllocation getMemoryManagement() {
        throw new RoStoreException("Not implemented yet...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(String containerName) {
        Container container = this.get(containerName);
        if (container == null) {
            return false;
        }
        container.remove();
        this.openedContainers.remove(containerName);
        try {
            Record record = new Record();
            this.keyBlockOperations.remove(containerName.getBytes(StandardCharsets.UTF_8), record);
            try (DataReader dr = DataReader.open(this.getMedia().getRootBlockAllocator(), record.getId());){
                dr.free();
            }
        }
        finally {
            this.keyBlockOperations.commit();
        }
        return true;
    }

    public synchronized List<String> listAllContainers() {
        KeyList keyList = this.keyBlockOperations.list(null, null, this.containerListHeader.getContainerListProperties().getMaxContainersPerList(), this.containerListHeader.getContainerListProperties().getMaxContainersListSize());
        if (keyList.isMore()) {
            throw new RoStoreException("There are too many (max number=" + this.containerListHeader.getContainerListProperties().getMaxContainersPerList() + ", max size =" + this.containerListHeader.getContainerListProperties().getMaxContainersListSize() + "B) containers.");
        }
        return keyList.getKeys().stream().map(f -> new String((byte[])f, StandardCharsets.UTF_8)).collect(Collectors.toList());
    }

    public Media getMedia() {
        return this.keyBlockOperations.getBlockSequence().getBlockProvider().getMedia();
    }

    public Container create(String containerName, ContainerMeta containerMeta) {
        return this.getOrExecute(containerName, () -> {
            try {
                Record record = this.keyBlockOperations.getRecord(containerName.getBytes(StandardCharsets.UTF_8));
                if (record != null) {
                    throw new ContainerAlreadyExistsException(containerName);
                }
                Container container = new Container(this, containerName, containerMeta);
                try {
                    long id = DataWriter.writeObject(this.getMedia().getRootBlockAllocator(), container.getDescriptor());
                    record = new Record().id(id).addOption(RecordOption.ONLY_INSERT);
                    this.keyBlockOperations.put(containerName.getBytes(StandardCharsets.UTF_8), record);
                    Container container2 = container;
                    return container2;
                }
                catch (Exception e) {
                    try {
                        block19: {
                            try {
                                if (record == null) break block19;
                                try (DataReader dr = DataReader.open(this.getMedia().getRootBlockAllocator(), record.getId());){
                                    dr.free();
                                }
                            }
                            finally {
                                container.remove();
                            }
                        }
                        throw e;
                    }
                    catch (Exception e2) {
                        throw new RoStoreException("Error while creating a new container \"" + containerName + "\".", e2);
                    }
                }
            }
            finally {
                this.keyBlockOperations.commit();
            }
        }, container -> {
            throw new RoStoreException("The container <" + containerName + "> already exists and opened.");
        });
    }

    public void evict(String name) {
        this.openedContainers.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Container getOrExecute(String containerName, Supplier<Container> factory, Consumer<Container> validateExisting) {
        Container container = this.openedContainers.get(containerName);
        if (container == null) {
            ContainerListOperations containerListOperations = this;
            synchronized (containerListOperations) {
                container = this.openedContainers.get(containerName);
                if (container == null) {
                    container = factory.get();
                    if (container != null) {
                        this.openedContainers.put(containerName, container);
                    }
                    return container;
                }
            }
        }
        if (container != null && validateExisting != null) {
            validateExisting.accept(container);
        }
        return container;
    }

    public ContainerListOperations(Media media, ContainerListProperties containerListProperties) {
        this.keyBlockOperations = KeyBlockOperations.create(media.getRootBlockAllocator(), RecordLengths.standardRecordLengths(media.getMediaProperties()));
        this.containerListHeader = new ContainerListHeader(containerListProperties);
        this.containerListHeader.setKeyStartIndex(this.keyBlockOperations.getStartIndex());
    }

    public ContainerListOperations(Media media, ContainerListHeader containerListHeader) {
        this.keyBlockOperations = KeyBlockOperations.load(media.getRootBlockAllocator(), containerListHeader.getKeyStartIndex(), RecordLengths.standardRecordLengths(media.getMediaProperties()));
        this.containerListHeader = containerListHeader;
    }
}

