/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.rostore.entity.BlockAllocationState;
import org.rostore.entity.RoStoreException;
import org.rostore.entity.media.ContainerMeta;
import org.rostore.v2.container.ContainerDescriptor;
import org.rostore.v2.container.ContainerListOperations;
import org.rostore.v2.container.ContainerShard;
import org.rostore.v2.media.Closeable;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.container.Status;

public class Container
implements Closeable {
    private static final Logger logger = Logger.getLogger(Container.class.getName());
    private final ContainerDescriptor descriptor;
    private final ContainerListOperations containerListOperations;
    private final ContainerShard[] shards;
    private final String name;
    private Status status = Status.OPENED;

    public BlockAllocationState getBlockAllocation() {
        BlockAllocationState memoryAllocationState = BlockAllocationState.init();
        for (int i = 0; i < this.descriptor.getContainerMeta().getShardNumber(); ++i) {
            ContainerShard containerShard = this.getShard(i);
            memoryAllocationState.plus(containerShard.getBlockAllocation());
        }
        return memoryAllocationState;
    }

    public String getName() {
        return this.name;
    }

    public ContainerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ContainerListOperations getContainerListOperations() {
        return this.containerListOperations;
    }

    public static final void checkFreeSpaceToCreateContainer(String name, Media media, ContainerMeta containerMeta) {
        if (containerMeta.getMaxSize() > media.getMediaProperties().getMaxTotalSize()) {
            throw new RoStoreException("Can't create container \"" + name + "\" with max size " + containerMeta.getMaxSize() + "B, for media of max size " + media.getMediaProperties().getMaxTotalSize() + "B.");
        }
        long totalFreeSize = media.getBlockAllocation().getLockedFreeSize();
        long minShardSize = 56L;
        long minSize = (long)containerMeta.getShardNumber() * minShardSize + 1L;
        long toleratedSize = minSize * 2L;
        if (toleratedSize > totalFreeSize) {
            throw new RoStoreException("Can't create container \"" + name + "\"  with tolerated size " + toleratedSize + "B, as media has " + totalFreeSize + "B of free space.");
        }
        if (containerMeta.getMaxSize() != 0L && toleratedSize > containerMeta.getMaxSize()) {
            throw new RoStoreException("Can't create container \"" + name + "\"  with tolerated size " + toleratedSize + "B, and requested max size of " + containerMeta.getMaxSize() + "B.");
        }
    }

    protected Container(ContainerListOperations containerListOperations, String name, ContainerDescriptor descriptor) {
        this.name = name;
        this.containerListOperations = containerListOperations;
        this.descriptor = descriptor;
        this.shards = new ContainerShard[descriptor.getContainerMeta().getShardNumber()];
    }

    protected void remove() {
        for (int i = 0; i < this.shards.length; ++i) {
            ContainerShard shard = this.shards[i];
            if (shard == null) {
                shard = ContainerShard.open(this, i, this.descriptor.getShardDescriptors().get(i));
            }
            shard.remove();
        }
    }

    protected Container(ContainerListOperations containerListOperations, String name, ContainerMeta containerMeta) {
        Container.checkFreeSpaceToCreateContainer(name, containerListOperations.getMedia(), containerMeta);
        this.name = name;
        this.containerListOperations = containerListOperations;
        this.descriptor = new ContainerDescriptor(containerMeta);
        this.shards = new ContainerShard[this.descriptor.getContainerMeta().getShardNumber()];
        try {
            for (int i = 0; i < this.descriptor.getContainerMeta().getShardNumber(); ++i) {
                ContainerShard containerShard = ContainerShard.create(this, i);
                this.descriptor.getShardDescriptors().add(containerShard.getDescriptor());
                this.shards[i] = containerShard;
            }
        }
        catch (Exception e) {
            for (int i = 0; i < this.descriptor.getContainerMeta().getShardNumber(); ++i) {
                if (this.shards[i] == null) continue;
                this.shards[i].remove();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerShard getShard(int shardIndex) {
        if (shardIndex < 0 || shardIndex >= this.getDescriptor().getContainerMeta().getShardNumber()) {
            throw new RoStoreException("There is no shard with index=" + shardIndex + ", max=" + this.getDescriptor().getContainerMeta().getShardNumber());
        }
        ContainerShard shard = this.shards[shardIndex];
        if (shard == null) {
            Container container = this;
            synchronized (container) {
                shard = this.shards[shardIndex];
                if (shard == null) {
                    if (shardIndex < 0 || shardIndex >= this.getDescriptor().getContainerMeta().getShardNumber()) {
                        throw new RoStoreException("Invalid shard index " + shardIndex + ", num=" + this.getDescriptor().getContainerMeta().getShardNumber());
                    }
                    this.shards[shardIndex] = shard = ContainerShard.open(this, shardIndex, this.descriptor.getShardDescriptors().get(shardIndex));
                }
            }
        }
        return shard;
    }

    protected void closeInternal() {
        this.status = Status.CLOSED;
        for (ContainerShard shard : this.shards) {
            try {
                if (shard == null) continue;
                shard.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in closing the container", e);
            }
        }
    }

    @Override
    public void close() {
        this.containerListOperations.closeContainer(this.name);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }
}

