/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import java.util.function.Consumer;
import java.util.function.Function;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockEntry;
import org.rostore.v2.catalog.CatalogBlockEntryInstance;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.fixsize.FixSizeEntryBlock;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.container.Status;
import org.rostore.v2.seq.BlockIndexSequence;
import org.rostore.v2.seq.BlockSequence;
import org.rostore.v2.seq.SequenceBlock;

public class CatalogBlockOperations
implements Committable {
    private final FixSizeEntryBlock<CatalogBlockEntry> catalogBlock;
    private final CatalogBlockEntry catalogBlockEntry;
    private boolean collapseNeeded = false;
    private boolean rebalanceNeeded = false;

    public long getSequenceIndexFreeBlockNumber() {
        return this.catalogBlock.getBlockSequence().getBlockIndexSequence().getFreeBlockNumber();
    }

    public BlockProvider getBlockProvider() {
        return this.catalogBlock.getBlockProvider();
    }

    public long getStartIndex() {
        return this.catalogBlock.getBlockSequence().getBlockIndexSequence().getBlockIndex(0);
    }

    public void iterateAll(Consumer<CatalogBlockIndices> entryConsumer) {
        this.checkOpened();
        this.catalogBlock.root();
        this.catalogBlockEntry.first();
        CatalogBlockIndices catalogBlockIndices = new CatalogBlockIndices();
        while (this.catalogBlockEntry.valid()) {
            catalogBlockIndices.add(this.catalogBlockEntry.getEntryStart(), this.catalogBlockEntry.getEntryStop());
            this.catalogBlockEntry.next();
            if (!this.catalogBlockEntry.invalid()) continue;
            if (!catalogBlockIndices.isEmpty()) {
                entryConsumer.accept(catalogBlockIndices);
                catalogBlockIndices = new CatalogBlockIndices();
            }
            this.catalogBlock.next();
            if (!this.catalogBlock.valid() || this.catalogBlock.getEntriesNumber() == 0) continue;
            this.catalogBlockEntry.first();
        }
    }

    public static CatalogBlockOperations load(BlockProvider blockProvider, long startIndex) {
        return new CatalogBlockOperations(cbo -> SequenceBlock.load(blockProvider, startIndex, sequence -> new FixSizeEntryBlock<CatalogBlockEntry>((BlockSequence<FixSizeEntryBlock>)sequence, blockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex(), b -> new CatalogBlockEntry((FixSizeEntryBlock<CatalogBlockEntry>)b), cbo::calculateCollapseNeeded), BlockType.CATALOG));
    }

    public static CatalogBlockOperations create(BlockProvider blockProvider, CatalogBlockIndices catalogBlockIndices) {
        return new CatalogBlockOperations(cbo -> SequenceBlock.create(blockProvider, catalogBlockIndices, sequence -> new FixSizeEntryBlock<CatalogBlockEntry>((BlockSequence<FixSizeEntryBlock>)sequence, blockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex(), b -> new CatalogBlockEntry((FixSizeEntryBlock<CatalogBlockEntry>)b), cbo::calculateCollapseNeeded), BlockType.CATALOG));
    }

    public static CatalogBlockOperations create(BlockProvider blockProvider) {
        return new CatalogBlockOperations(cbo -> SequenceBlock.create(blockProvider, sequence -> new FixSizeEntryBlock<CatalogBlockEntry>((BlockSequence<FixSizeEntryBlock>)sequence, blockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex(), b -> new CatalogBlockEntry((FixSizeEntryBlock<CatalogBlockEntry>)b), cbo::calculateCollapseNeeded), BlockType.CATALOG));
    }

    private void calculateCollapseNeeded(long newEntrySize, long delta) {
        if (!this.catalogBlock.isRoot() && delta < 0L && newEntrySize < (long)(this.catalogBlock.getEntryCapacity() / 2)) {
            this.collapseNeeded = true;
        }
    }

    private CatalogBlockOperations(Function<CatalogBlockOperations, FixSizeEntryBlock<CatalogBlockEntry>> catalogBlockFactory) {
        this.catalogBlock = catalogBlockFactory.apply(this);
        this.catalogBlockEntry = this.catalogBlock.getEntry();
    }

    public void dump() {
        this.catalogBlock.root();
        while (this.catalogBlock.valid()) {
            if (this.catalogBlock.isRoot()) {
                System.out.println(this.catalogBlock.getBlock().getAbsoluteIndex() + ":" + this.catalogBlock.getEntriesNumber() + " of " + this.catalogBlock.getEntryCapacity() + ", added=" + this.catalogBlockEntry.getAddedNumber());
            } else {
                System.out.println(this.catalogBlock.getBlock().getAbsoluteIndex() + ":" + this.catalogBlock.getEntriesNumber() + " of " + this.catalogBlock.getEntryCapacity());
            }
            for (int i = 0; i < this.catalogBlock.getEntriesNumber(); ++i) {
                this.catalogBlockEntry.moveTo(i);
                System.out.println(" " + this.catalogBlockEntry.getIndex() + ": " + this.catalogBlockEntry.getEntryStart() + " -> " + this.catalogBlockEntry.getEntryStop());
            }
            this.catalogBlock.next();
        }
        this.catalogBlock.last();
        int lastActiveIndex = this.catalogBlock.getIndex();
        BlockIndexSequence blockIndexSequence = this.catalogBlock.getBlockSequence().getBlockIndexSequence();
        for (int i = lastActiveIndex + 1; i < blockIndexSequence.length(); ++i) {
            System.out.println(blockIndexSequence.getBlockIndex(i) + ": free");
        }
    }

    private void incAddedNumber(long added) {
        this.catalogBlock.root();
        this.catalogBlockEntry.incAddedNumber(added);
    }

    public long getAddedNumber() {
        this.checkOpened();
        this.catalogBlock.root();
        return this.catalogBlockEntry.getAddedNumber();
    }

    public CatalogBlockIndices extractIndex(long number, boolean rebalance) {
        this.checkOpened();
        CatalogBlockIndices indices = new CatalogBlockIndices();
        this.catalogBlock.last();
        while ((long)indices.getLength() != number && this.catalogBlock.getEntriesNumber() != 0) {
            this.catalogBlockEntry.last();
            long entryBlockNumber = this.catalogBlockEntry.getBlocksNumber();
            long left = number - (long)indices.getLength();
            if (entryBlockNumber <= left) {
                indices.add(this.catalogBlockEntry.getEntryStart(), this.catalogBlockEntry.getEntryStop());
                this.catalogBlockEntry.remove();
                if (!this.catalogBlock.isRoot() && this.catalogBlock.getEntriesNumber() == 0) {
                    this.rebalanceNeeded = true;
                    this.catalogBlock.delete();
                }
                this.catalogBlock.last();
            } else {
                entryBlockNumber = left;
                indices.add(this.catalogBlockEntry.getEntryStop() - left + 1L, this.catalogBlockEntry.getEntryStop());
                this.catalogBlockEntry.setEntryStop(this.catalogBlockEntry.getEntryStop() - left);
            }
            this.incAddedNumber(-entryBlockNumber);
            this.rebalance(rebalance);
            this.catalogBlock.last();
        }
        return indices;
    }

    private void rebalance(boolean rebalance) {
        if (this.collapseNeeded) {
            this.collapse();
            this.collapseNeeded = false;
        }
        if (this.rebalanceNeeded && rebalance) {
            this.catalogBlock.getBlockSequence().rebalance();
            this.rebalanceNeeded = false;
        }
    }

    private void collapse() {
        this.catalogBlock.root();
        while (this.catalogBlock.valid()) {
            int tolerance = this.catalogBlock.getEntryCapacity() / 2;
            int prevEntryCapacityLeft = this.catalogBlock.getEntryCapacity() - this.catalogBlock.getEntriesNumber();
            this.catalogBlock.next();
            if (!this.catalogBlock.valid()) {
                return;
            }
            int nextEntryNumber = this.catalogBlock.getEntriesNumber();
            if (prevEntryCapacityLeft - nextEntryNumber < tolerance) continue;
            this.catalogBlock.previous();
            this.catalogBlock.moveEntriesFrom(this.catalogBlock.getIndex() + 1, 0);
            this.rebalanceNeeded = true;
            this.catalogBlock.delete();
        }
    }

    private void searchAfterBlockOrBlock(long stopBlockIndex) {
        this.catalogBlock.root();
        if (this.catalogBlock.getEntriesNumber() == 0 && this.catalogBlock.getBlockSequence().length() != 1) {
            this.catalogBlock.next();
        }
        this.catalogBlockEntry.last();
        if (this.catalogBlockEntry.invalid()) {
            return;
        }
        if (stopBlockIndex > this.catalogBlockEntry.getEntryStop()) {
            int startIndex = 0;
            int stopIndex = this.catalogBlock.getBlockSequence().length() - 1;
            if (startIndex != stopIndex) {
                while (stopIndex - startIndex != 1) {
                    int next = (startIndex + stopIndex) / 2;
                    this.catalogBlock.moveTo(next);
                    this.catalogBlockEntry.last();
                    if (stopBlockIndex <= this.catalogBlockEntry.getEntryStop()) {
                        stopIndex = next;
                        continue;
                    }
                    startIndex = next;
                }
            }
            this.catalogBlock.moveTo(stopIndex);
        }
        this.searchInBlock(stopBlockIndex);
    }

    private void searchInBlock(long stopBlockIndex) {
        this.catalogBlockEntry.first();
        if (stopBlockIndex > this.catalogBlockEntry.getEntryStop()) {
            int startIndex = 0;
            int stopIndex = this.catalogBlock.getEntriesNumber() - 1;
            if (startIndex == stopIndex) {
                return;
            }
            while (stopIndex - startIndex != 1) {
                int next = (startIndex + stopIndex) / 2;
                this.catalogBlockEntry.moveTo(next);
                if (stopBlockIndex <= this.catalogBlockEntry.getEntryStop()) {
                    stopIndex = next;
                    continue;
                }
                startIndex = next;
            }
            this.catalogBlockEntry.moveTo(stopIndex);
        }
    }

    public void add(CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        this.checkOpened();
        for (int i = 0; i < catalogBlockIndices.getGroupNumber(); ++i) {
            this.add(catalogBlockIndices.getGroup(i)[0], catalogBlockIndices.getGroup(i)[1], rebalance);
        }
    }

    public void remove(CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        this.checkOpened();
        for (int i = 0; i < catalogBlockIndices.getGroupNumber(); ++i) {
            this.remove(catalogBlockIndices.getGroup(i)[0], catalogBlockIndices.getGroup(i)[1], rebalance);
        }
    }

    public void add(long startIndex, long stopIndex, boolean rebalance) {
        this.checkOpened();
        if (stopIndex < startIndex) {
            throw new RoStoreException("Try to add an inconsistent block: " + startIndex + ".." + stopIndex);
        }
        if (this.addEdgeCases(startIndex, stopIndex)) {
            this.rebalance(rebalance);
            return;
        }
        this.searchAfterBlockOrBlock(stopIndex);
        if (stopIndex >= this.catalogBlockEntry.getEntryStart() && stopIndex <= this.catalogBlockEntry.getEntryStop() || startIndex >= this.catalogBlockEntry.getEntryStart() && startIndex <= this.catalogBlockEntry.getEntryStop()) {
            throw new RoStoreException("The blocks " + startIndex + ".." + stopIndex + " have already been added to catalogue.");
        }
        CatalogBlockEntryInstance after = new CatalogBlockEntryInstance(this.catalogBlockEntry, this.catalogBlockEntry.getHash());
        if (this.catalogBlockEntry.isFirst()) {
            this.catalogBlock.previous();
            this.catalogBlockEntry.last();
        } else {
            this.catalogBlockEntry.previous();
        }
        if (stopIndex >= this.catalogBlockEntry.getEntryStart() && stopIndex <= this.catalogBlockEntry.getEntryStop() || startIndex >= this.catalogBlockEntry.getEntryStart() && startIndex <= this.catalogBlockEntry.getEntryStop()) {
            throw new RoStoreException("The blocks " + startIndex + ".." + stopIndex + " have already been added to catalogue.");
        }
        CatalogBlockEntryInstance before = new CatalogBlockEntryInstance(this.catalogBlockEntry, this.catalogBlockEntry.getHash());
        if (after.getStart() == stopIndex + 1L && before.getStop() == startIndex - 1L) {
            before.restore();
            this.catalogBlockEntry.setEntryStop(after.getStop());
            after.restore();
            this.catalogBlockEntry.remove();
            if (this.catalogBlock.getEntriesNumber() == 0 && !this.catalogBlock.isRoot()) {
                this.rebalanceNeeded = true;
                this.catalogBlock.delete();
            }
        } else if (after.getStart() == stopIndex + 1L) {
            after.restore();
            this.catalogBlockEntry.setEntryStart(startIndex);
        } else if (before.getStop() == startIndex - 1L) {
            before.restore();
            this.catalogBlockEntry.setEntryStop(stopIndex);
        } else {
            after.restore();
            if (this.catalogBlock.hasFreeSpace()) {
                this.catalogBlockEntry.insert();
                this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
            } else {
                before.restore();
                if (this.catalogBlock.hasFreeSpace()) {
                    this.catalogBlockEntry.expand();
                    this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
                } else {
                    this.insertAfter(startIndex, stopIndex);
                }
            }
        }
        this.incAddedNumber(stopIndex - startIndex + 1L);
        this.rebalance(rebalance);
    }

    public void remove(long startIndex, long stopIndex, boolean rebalance) {
        this.checkOpened();
        if (stopIndex < startIndex) {
            throw new RoStoreException("Try to remove an inconsistent block: " + startIndex + ".." + stopIndex);
        }
        this.searchAfterBlockOrBlock(stopIndex);
        if (this.catalogBlockEntry.invalid() || startIndex < this.catalogBlockEntry.getEntryStart() || stopIndex > this.catalogBlockEntry.getEntryStop()) {
            throw new RoStoreException("The block " + startIndex + ".." + stopIndex + " is not consistent with catalog structure.");
        }
        if (this.catalogBlockEntry.getEntryStart() == startIndex) {
            if (this.catalogBlockEntry.getEntryStop() == stopIndex) {
                this.catalogBlockEntry.remove();
                if (this.catalogBlock.getEntriesNumber() == 0 && !this.catalogBlock.isRoot()) {
                    this.rebalanceNeeded = true;
                    this.catalogBlock.delete();
                }
            } else {
                this.catalogBlockEntry.setEntryStart(stopIndex + 1L);
            }
        } else if (this.catalogBlockEntry.getEntryStop() == stopIndex) {
            this.catalogBlockEntry.setEntryStop(startIndex - 1L);
        } else {
            long newEntryStop = this.catalogBlockEntry.getEntryStop();
            this.catalogBlockEntry.setEntryStop(startIndex - 1L);
            long newEntryStart = stopIndex + 1L;
            if (this.catalogBlock.hasFreeSpace()) {
                this.catalogBlockEntry.next();
                if (this.catalogBlockEntry.invalid()) {
                    this.catalogBlockEntry.expand();
                } else {
                    this.catalogBlockEntry.insert();
                }
                this.catalogBlockEntry.setEntryStartStop(newEntryStart, newEntryStop);
            } else {
                this.catalogBlockEntry.next();
                if (this.catalogBlockEntry.invalid()) {
                    this.catalogBlock.next();
                    if (this.catalogBlock.valid()) {
                        if (this.catalogBlock.hasFreeSpace()) {
                            this.catalogBlockEntry.first();
                            this.catalogBlockEntry.insert();
                            this.catalogBlockEntry.setEntryStartStop(newEntryStart, newEntryStop);
                        } else {
                            this.catalogBlock.previous();
                            this.catalogBlock.createNewAfter();
                            this.catalogBlockEntry.addNewEntryFor(newEntryStart, newEntryStop);
                        }
                    } else {
                        this.catalogBlock.last();
                        this.catalogBlock.createNewAfter();
                        this.catalogBlockEntry.addNewEntryFor(newEntryStart, newEntryStop);
                    }
                } else {
                    this.catalogBlockEntry.previous();
                    this.insertAfter(newEntryStart, newEntryStop);
                }
            }
        }
        this.incAddedNumber(-(stopIndex - startIndex + 1L));
        this.rebalance(rebalance);
    }

    private boolean addEdgeCases(long startIndex, long stopIndex) {
        this.catalogBlock.root();
        if (this.catalogBlock.getEntriesNumber() == 0) {
            if (this.catalogBlock.getBlockSequence().length() == 1) {
                this.catalogBlock.root();
                this.catalogBlockEntry.expand();
                this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
                this.incAddedNumber(stopIndex - startIndex + 1L);
                return true;
            }
            this.catalogBlock.next();
            this.catalogBlockEntry.first();
            if (stopIndex < this.catalogBlockEntry.getEntryStart()) {
                if (this.catalogBlockEntry.getEntryStart() == stopIndex + 1L) {
                    this.catalogBlockEntry.setEntryStart(startIndex);
                    this.incAddedNumber(stopIndex - startIndex + 1L);
                    return true;
                }
                this.catalogBlock.root();
                this.catalogBlockEntry.expand();
                this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
                this.incAddedNumber(stopIndex - startIndex + 1L);
                return true;
            }
        }
        this.catalogBlockEntry.first();
        if (stopIndex < this.catalogBlockEntry.getEntryStart()) {
            if (this.catalogBlockEntry.getEntryStart() == stopIndex + 1L) {
                this.catalogBlockEntry.setEntryStart(startIndex);
                this.incAddedNumber(stopIndex - startIndex + 1L);
                return true;
            }
            if (this.catalogBlock.hasFreeSpace()) {
                this.catalogBlockEntry.insert();
                this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
                this.incAddedNumber(stopIndex - startIndex + 1L);
                return true;
            }
            int numberToStart = this.catalogBlock.getEntriesNumber() / 2;
            this.rebalanceNeeded = true;
            this.catalogBlock.createNewAfter();
            this.catalogBlock.moveEntriesFrom(0, numberToStart);
            this.catalogBlock.root();
            this.catalogBlockEntry.insert();
            this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
            this.incAddedNumber(stopIndex - startIndex + 1L);
            return true;
        }
        this.catalogBlock.last();
        this.catalogBlockEntry.last();
        if (startIndex > this.catalogBlockEntry.getEntryStop()) {
            if (this.catalogBlockEntry.getEntryStop() == startIndex - 1L) {
                this.catalogBlockEntry.setEntryStop(stopIndex);
                this.incAddedNumber(stopIndex - startIndex + 1L);
                return true;
            }
            if (this.catalogBlock.hasFreeSpace()) {
                this.catalogBlockEntry.expand();
                this.catalogBlockEntry.setEntryStartStop(startIndex, stopIndex);
                this.incAddedNumber(stopIndex - startIndex + 1L);
                return true;
            }
            this.rebalanceNeeded = true;
            this.catalogBlock.createNewAfter();
            this.catalogBlockEntry.addNewEntryFor(startIndex, stopIndex);
            this.incAddedNumber(stopIndex - startIndex + 1L);
            return true;
        }
        return false;
    }

    private void insertAfter(long startIndex, long stopIndex) {
        int beforeBlockIndex = this.catalogBlock.getIndex();
        int moveStartIndex = this.catalogBlockEntry.getIndex() + 1;
        if (moveStartIndex >= this.catalogBlock.getEntriesNumber()) {
            moveStartIndex = -1;
        }
        this.rebalanceNeeded = true;
        this.catalogBlock.createNewAfter();
        this.catalogBlockEntry.addNewEntryFor(startIndex, stopIndex);
        if (moveStartIndex != -1) {
            this.catalogBlock.moveEntriesFrom(beforeBlockIndex, moveStartIndex);
        }
    }

    @Override
    public void close() {
        this.commit();
        this.catalogBlock.getBlockSequence().close();
    }

    @Override
    public Status getStatus() {
        return this.catalogBlock.getStatus();
    }

    @Override
    public void commit() {
        this.catalogBlock.getBlockProvider().getBlockContainer().commit();
    }
}

