/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockIndices;

public class CatalogBlockIndicesIterator {
    private final CatalogBlockIndices blockIndices;
    private int groupIndex = -1;
    private int inGroupIndex = -1;
    private int position = -1;

    public CatalogBlockIndicesIterator(CatalogBlockIndices blockIndices) {
        this.blockIndices = blockIndices;
        if (!blockIndices.isEmpty()) {
            this.groupIndex = 0;
            this.inGroupIndex = 0;
            this.position = 0;
        }
    }

    public boolean isEmpty() {
        return this.blockIndices.isEmpty();
    }

    public boolean isValid() {
        return this.groupIndex != -1;
    }

    public int position() {
        return this.position;
    }

    public int left() {
        if (this.isValid()) {
            return this.blockIndices.getLength() - this.position;
        }
        return 0;
    }

    private void invalidate() {
        this.groupIndex = -1;
        this.position = -1;
        this.inGroupIndex = -1;
    }

    private long currentGroupLength() {
        long[] group = this.blockIndices.getGroup(this.groupIndex);
        return group[1] - group[0] + 1L;
    }

    public long get() {
        if (!this.isValid()) {
            throw new RoStoreException("Get from invalid iterator");
        }
        long value = this.blockIndices.getGroup(this.groupIndex)[0] + (long)this.inGroupIndex;
        ++this.inGroupIndex;
        ++this.position;
        if ((long)this.inGroupIndex >= this.currentGroupLength()) {
            ++this.groupIndex;
            this.inGroupIndex = 0;
            if (this.groupIndex >= this.blockIndices.getGroupNumber()) {
                this.invalidate();
            }
        }
        return value;
    }
}

