/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import org.rostore.entity.RoStoreException;
import org.rostore.v2.fixsize.FixSizeEntry;
import org.rostore.v2.fixsize.FixSizeEntryBlock;
import org.rostore.v2.media.block.Block;

public class CatalogBlockEntry
extends FixSizeEntry {
    public CatalogBlockEntry(FixSizeEntryBlock<CatalogBlockEntry> freeBlock) {
        super(freeBlock);
    }

    public long getAddedNumber() {
        FixSizeEntryBlock rootBlock = this.getFixSizeEntryBlock();
        if (!rootBlock.isRoot()) {
            throw new RoStoreException("This operation is only allowed on root");
        }
        Block block = rootBlock.getBlock();
        block.position(rootBlock.getRegularHeaderSize());
        return block.readBlockIndex();
    }

    public void incAddedNumber(long added) {
        FixSizeEntryBlock root = this.getFixSizeEntryBlock();
        Block block = root.getBlock();
        long number = this.getAddedNumber() + added;
        block.backBlockIndex();
        block.writeBlockIndex(number);
    }

    public void addNewEntryFor(long startIndex, long stopIndex) {
        this.expand();
        this.setEntryStartStop(startIndex, stopIndex);
    }

    public long getBlocksNumber() {
        this.throwExceptionIfInvalid("get number of blocks");
        return this.getEntryStop() - this.getEntryStart() + 1L;
    }

    public void setEntryStart(long newStart) {
        this.throwExceptionIfInvalid("set entry start");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation());
        block.writeBlockIndex(newStart);
    }

    public void setEntryStartStop(long newStart, long newStop) {
        this.throwExceptionIfInvalid("set entry start/stop");
        int location = this.getEntryLocation();
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(location);
        block.writeBlockIndex(newStart);
        block.writeBlockIndex(newStop);
    }

    public long getEntryStart() {
        this.throwExceptionIfInvalid("get entry start");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation());
        return block.readBlockIndex();
    }

    public void setEntryStop(long newStop) {
        this.throwExceptionIfInvalid("set entry stop");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        block.writeBlockIndex(newStop);
    }

    public long getEntryStop() {
        this.throwExceptionIfInvalid("get entry stop");
        Block block = this.getFixSizeEntryBlock().getBlock();
        int bytesPerBlockIndex = this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
        block.position(this.getEntryLocation() + bytesPerBlockIndex);
        return block.readBlockIndex();
    }

    @Override
    public int getEntrySize() {
        return this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() * 2;
    }
}

