/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import java.util.function.Consumer;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.catalog.CatalogBlockOperations;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.container.Status;

public class CachedCatalogBlockOperations
implements Committable {
    private final CatalogBlockOperations catalogBlockOperations;
    private final int minCacheSize;
    private final int maxCacheSize;
    private final int avgCacheSize;
    private final CatalogBlockIndices cache;

    public long getSequenceIndexFreeBlockNumber() {
        return this.catalogBlockOperations.getSequenceIndexFreeBlockNumber();
    }

    public long getCachedBlockNumber() {
        return this.cache.getLength();
    }

    public BlockProvider getBlockProvider() {
        return this.catalogBlockOperations.getBlockProvider();
    }

    public CachedCatalogBlockOperations(CatalogBlockOperations catalogBlockOperations, int minCacheSize, int maxCacheSize) {
        this.catalogBlockOperations = catalogBlockOperations;
        this.maxCacheSize = maxCacheSize;
        this.minCacheSize = minCacheSize;
        this.avgCacheSize = (maxCacheSize + minCacheSize) / 2;
        this.cache = new CatalogBlockIndices();
    }

    public long getAddedNumber() {
        return this.catalogBlockOperations.getAddedNumber();
    }

    public CatalogBlockIndices extractIndex(int blockNumber, boolean rebalance) {
        this.checkOpened();
        if (this.cache.getLength() >= blockNumber) {
            CatalogBlockIndices ret = this.cache.extract(blockNumber);
            if (rebalance && this.cache.getLength() < this.minCacheSize) {
                int cacheCapacity = this.avgCacheSize - this.cache.getLength();
                CatalogBlockIndices extracted = this.catalogBlockOperations.extractIndex(cacheCapacity, rebalance);
                this.cache.add(extracted);
            }
            return ret;
        }
        if (rebalance) {
            int cacheCapacity = this.cache.getLength() < this.minCacheSize ? this.avgCacheSize - this.cache.getLength() : 0;
            CatalogBlockIndices extracted = this.catalogBlockOperations.extractIndex(blockNumber + cacheCapacity, rebalance);
            if (cacheCapacity != 0) {
                CatalogBlockIndices ret = extracted.extract(blockNumber);
                this.cache.add(extracted);
                return ret;
            }
            return extracted;
        }
        int fromCache = this.cache.getLength();
        CatalogBlockIndices ret = this.cache.extract(fromCache);
        int left = blockNumber - fromCache;
        CatalogBlockIndices extracted = this.catalogBlockOperations.extractIndex(left, rebalance);
        ret.add(extracted);
        return ret;
    }

    public void add(CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        this.checkOpened();
        this.cache.add(catalogBlockIndices);
        if (rebalance && this.cache.getLength() > this.maxCacheSize) {
            int cacheFreeSize = this.cache.getLength() - this.avgCacheSize;
            CatalogBlockIndices toReturn = this.cache.extract(cacheFreeSize);
            this.catalogBlockOperations.add(toReturn, rebalance);
        }
    }

    public void remove(CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        this.checkOpened();
        CatalogBlockIndices notRemoved = this.cache.remove(catalogBlockIndices);
        if (!notRemoved.isEmpty()) {
            this.catalogBlockOperations.remove(notRemoved, rebalance);
        }
        if (rebalance) {
            int cacheCapacity;
            int n = cacheCapacity = this.cache.getLength() < this.minCacheSize ? this.avgCacheSize - this.cache.getLength() : 0;
            if (cacheCapacity != 0) {
                CatalogBlockIndices extracted = this.catalogBlockOperations.extractIndex(cacheCapacity, rebalance);
                this.cache.add(extracted);
            }
        }
    }

    @Override
    public void close() {
        this.catalogBlockOperations.add(this.cache, true);
        this.cache.clear();
        this.catalogBlockOperations.close();
    }

    @Override
    public Status getStatus() {
        return this.catalogBlockOperations.getStatus();
    }

    @Override
    public void commit() {
        this.catalogBlockOperations.commit();
    }

    public void dump() {
        System.out.println(">b---------------------------------");
        System.out.println("cache=" + this.cache.toString());
        this.catalogBlockOperations.dump();
        System.out.println("<e---------------------------------");
    }

    public long getStartIndex() {
        return this.catalogBlockOperations.getStartIndex();
    }

    public Media getMedia() {
        return this.catalogBlockOperations.getBlockProvider().getMedia();
    }

    public void iterateAll(Consumer<CatalogBlockIndices> consumer) {
        consumer.accept(this.cache);
        this.catalogBlockOperations.iterateAll(consumer);
    }
}

