/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.entity;

import org.rostore.entity.Record;
import org.rostore.entity.RoStoreException;
import org.rostore.entity.media.RecordOption;
import org.rostore.v2.keys.KeyBlockEntry;

public class OptionMismatchException
extends RoStoreException {
    private final Record record;

    public Record getRecord() {
        return this.record;
    }

    public static void checkUpdateRecord(KeyBlockEntry entry, Record record) {
        if (record.hasOption(RecordOption.ONLY_INSERT) && !entry.isExpired()) {
            throw new OptionMismatchException("Record id=" + record.getId() + " can't be inserted, but replaced.", record);
        }
    }

    public static void checkInsertRecord(Record record) {
        if (record.hasOption(RecordOption.ONLY_REPLACE)) {
            throw new OptionMismatchException("Record id=" + record.getId() + " can't be replaced, but only inserted.", record);
        }
    }

    private OptionMismatchException(String message, Record record) {
        super(message);
        this.record = record;
    }
}

