/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.entity;

import org.rostore.entity.BlockAllocation;

public class BlockAllocationState
implements BlockAllocation {
    private long payloadSize;
    private long totalLockedSize;
    private long lockedFreeSize;

    public static BlockAllocationState init() {
        return new BlockAllocationState();
    }

    public static BlockAllocationState init(long totalLockedSize, long lockedFreeSize, long payloadSize) {
        BlockAllocationState memoryAllocationState = new BlockAllocationState();
        memoryAllocationState.totalLockedSize = totalLockedSize;
        memoryAllocationState.lockedFreeSize = lockedFreeSize;
        memoryAllocationState.payloadSize = payloadSize;
        return memoryAllocationState;
    }

    public static BlockAllocationState store(BlockAllocation blockAllocation) {
        return new BlockAllocationState(blockAllocation);
    }

    public synchronized void minus(BlockAllocation blockAllocation) {
        this.payloadSize -= blockAllocation.getPayloadSize();
        this.totalLockedSize -= blockAllocation.getTotalLockedSize();
        this.lockedFreeSize -= blockAllocation.getLockedFreeSize();
    }

    public synchronized void plus(BlockAllocation blockAllocation) {
        this.payloadSize += blockAllocation.getPayloadSize();
        this.totalLockedSize += blockAllocation.getTotalLockedSize();
        this.lockedFreeSize += blockAllocation.getLockedFreeSize();
    }

    private BlockAllocationState() {
        this.totalLockedSize = 0L;
        this.payloadSize = 0L;
        this.lockedFreeSize = 0L;
    }

    private BlockAllocationState(long payloadSize) {
        this.totalLockedSize = payloadSize;
        this.payloadSize = payloadSize;
        this.lockedFreeSize = 0L;
    }

    private BlockAllocationState(BlockAllocation blockAllocation) {
        this.totalLockedSize = blockAllocation.getTotalLockedSize();
        this.payloadSize = blockAllocation.getPayloadSize();
        this.lockedFreeSize = blockAllocation.getLockedFreeSize();
    }

    @Override
    public long getPayloadSize() {
        return this.payloadSize;
    }

    @Override
    public long getTotalLockedSize() {
        return this.totalLockedSize;
    }

    @Override
    public long getLockedFreeSize() {
        return this.lockedFreeSize;
    }

    public String toString() {
        return "MemoryAllocationState{payload=" + this.payloadSize + ", totalLocked=" + this.totalLockedSize + ", lockedFree=" + this.lockedFreeSize + "}";
    }
}

