/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.seq;

import java.util.function.Function;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.catalog.CatalogBlockIndicesIterator;
import org.rostore.v2.media.RootClosableImpl;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.seq.BlockIndexSequence;
import org.rostore.v2.seq.SequenceBlock;

public class BlockSequence<T extends SequenceBlock>
extends RootClosableImpl {
    private final BlockIndexSequence blockIndexSequence;
    private final T sequenceBlock;
    private final BlockProvider blockProvider;
    private final BlockType blockType;

    public BlockProvider getBlockProvider() {
        return this.blockProvider;
    }

    public T getSequenceBlock() {
        return this.sequenceBlock;
    }

    public int length() {
        return this.blockIndexSequence.getFirstFreeIndex();
    }

    public void rebalance() {
        this.checkOpened();
        int freeNumber = this.blockIndexSequence.length() - this.blockIndexSequence.getFirstFreeIndex();
        if (freeNumber < 3) {
            int alloc = 4 - freeNumber;
            this.addFreeBlocks(alloc);
            return;
        }
        if (freeNumber > 5) {
            int free = freeNumber - 4;
            this.removeFreeBlocks(free);
            return;
        }
    }

    private void removeFreeBlocks(int numberOfBlocks) {
        int freeStartIndex = this.blockIndexSequence.length() - numberOfBlocks;
        CatalogBlockIndices toFree = new CatalogBlockIndices();
        for (int i = freeStartIndex; i < this.blockIndexSequence.length(); ++i) {
            long blockIndex = this.getBlockByIndex(i).getAbsoluteIndex();
            toFree.add(blockIndex, blockIndex);
        }
        this.blockIndexSequence.removeAtEnd(numberOfBlocks);
        Block block = this.getBlockByIndex(this.blockIndexSequence.length() - 1);
        block.position(0);
        block.writeBlockIndex(0L);
        this.blockProvider.getBlockAllocator().getBlockAllocatorInternal().free(toFree, false);
    }

    private void addFreeBlocks(int numberOfBlocks) {
        CatalogBlockIndices toAdd = this.blockProvider.getBlockAllocator().getBlockAllocatorInternal().allocate(this.blockType, numberOfBlocks, false);
        CatalogBlockIndicesIterator indices = toAdd.iterator();
        int index = this.blockIndexSequence.length();
        Block prevBlock = this.getBlockByIndex(this.blockIndexSequence.length() - 1);
        while (indices.left() != 0) {
            long blockIndex = indices.get();
            this.blockIndexSequence.add(index, blockIndex);
            Block block = this.blockProvider.getBlockContainer().getBlock(blockIndex, this.blockType);
            ((SequenceBlock)this.sequenceBlock).moveTo(index);
            ((SequenceBlock)this.sequenceBlock).clean();
            if (prevBlock != null) {
                prevBlock.position(0);
                prevBlock.writeBlockIndex(blockIndex);
            }
            ++index;
            prevBlock = block;
        }
    }

    public void addFreeBlock(int afterIndex) {
        this.checkOpened();
        if (afterIndex == this.blockIndexSequence.getFirstFreeIndex() - 1) {
            this.blockIndexSequence.setFirstFreeIndex(this.blockIndexSequence.getFirstFreeIndex() + 1);
            return;
        }
        Block beforeBlock = this.getBlockByIndex(afterIndex);
        Block freeBlock = this.getBlockByIndex(this.blockIndexSequence.getFirstFreeIndex());
        Block preFreeBlock = this.getBlockByIndex(this.blockIndexSequence.getFirstFreeIndex() - 1);
        freeBlock.position(0);
        long nextAfterFree = freeBlock.readBlockIndex();
        preFreeBlock.position(0);
        preFreeBlock.writeBlockIndex(nextAfterFree);
        beforeBlock.position(0);
        long nextBlock = beforeBlock.readBlockIndex();
        beforeBlock.backBlockIndex();
        beforeBlock.writeBlockIndex(freeBlock.getAbsoluteIndex());
        freeBlock.position(0);
        freeBlock.writeBlockIndex(nextBlock);
        this.blockIndexSequence.remove(this.blockIndexSequence.getFirstFreeIndex());
        this.blockIndexSequence.add(afterIndex + 1, freeBlock.getAbsoluteIndex());
        this.blockIndexSequence.setFirstFreeIndex(this.blockIndexSequence.getFirstFreeIndex() + 1);
    }

    public void removeFreeBlock(int index) {
        this.checkOpened();
        if (index == 0) {
            throw new RoStoreException("Can't free the first block");
        }
        if (index == this.blockIndexSequence.getFirstFreeIndex() - 1) {
            this.blockIndexSequence.setFirstFreeIndex(this.blockIndexSequence.getFirstFreeIndex() - 1);
            ((SequenceBlock)this.sequenceBlock).moveTo(this.blockIndexSequence.getFirstFreeIndex());
            ((SequenceBlock)this.sequenceBlock).clean();
            return;
        }
        Block freeBlock = this.getBlockByIndex(index);
        freeBlock.position(0);
        long nextBlock = freeBlock.readBlockIndex();
        Block beforeBlock = this.getBlockByIndex(index - 1);
        beforeBlock.position(0);
        beforeBlock.writeBlockIndex(nextBlock);
        this.blockIndexSequence.remove(index);
        this.blockIndexSequence.setFirstFreeIndex(this.blockIndexSequence.getFirstFreeIndex() - 1);
        Block lastBlock = this.getBlockByIndex(this.blockIndexSequence.length() - 1);
        this.blockIndexSequence.add(this.blockIndexSequence.length(), freeBlock.getAbsoluteIndex());
        lastBlock.position(0);
        lastBlock.writeBlockIndex(freeBlock.getAbsoluteIndex());
        ((SequenceBlock)this.sequenceBlock).moveTo(this.blockIndexSequence.length() - 1);
        ((SequenceBlock)this.sequenceBlock).clean();
    }

    public BlockSequence(BlockProvider blockProvider, CatalogBlockIndices catalogBlockIndices, Function<BlockSequence<T>, T> factory, BlockType blockType) {
        this.blockType = blockType;
        this.blockProvider = blockProvider;
        this.blockIndexSequence = new BlockIndexSequence();
        this.sequenceBlock = (SequenceBlock)factory.apply(this);
        CatalogBlockIndicesIterator indices = catalogBlockIndices.iterator();
        int index = 0;
        Block prevBlock = null;
        while (indices.left() != 0) {
            long blockIndex = indices.get();
            this.blockIndexSequence.add(index, blockIndex);
            Block block = blockProvider.getBlockContainer().getBlock(blockIndex, blockType);
            ((SequenceBlock)this.sequenceBlock).moveTo(index);
            ((SequenceBlock)this.sequenceBlock).clean();
            ++index;
            if (prevBlock != null) {
                prevBlock.position(0);
                prevBlock.writeBlockIndex(blockIndex);
            }
            prevBlock = block;
        }
        this.blockIndexSequence.setFirstFreeIndex(1);
        this.blockIndexSequence.markSequenceUsed();
    }

    public BlockSequence(BlockProvider blockProvider, BlockIndexSequence blockIndexSequence, Function<BlockSequence<T>, T> factory, BlockType blockType) {
        this.blockType = blockType;
        this.blockProvider = blockProvider;
        this.blockIndexSequence = blockIndexSequence;
        this.blockIndexSequence.markSequenceUsed();
        this.sequenceBlock = (SequenceBlock)factory.apply(this);
    }

    public BlockSequence(BlockProvider blockProvider, long startBlockIndex, Function<BlockSequence<T>, T> factory, BlockType blockType) {
        this.blockType = blockType;
        this.blockProvider = blockProvider;
        this.blockIndexSequence = new BlockIndexSequence();
        this.sequenceBlock = (SequenceBlock)factory.apply(this);
        Block block = blockProvider.getBlockContainer().getBlock(startBlockIndex, blockType);
        int firstFreeIndex = -1;
        int index = 0;
        while (block != null) {
            this.blockIndexSequence.add(index, block.getAbsoluteIndex());
            long nextBlck = block.readBlockIndex();
            ((SequenceBlock)this.sequenceBlock).moveTo(index);
            if (firstFreeIndex == -1 && ((SequenceBlock)this.sequenceBlock).isUnused()) {
                firstFreeIndex = index;
            }
            block = nextBlck != 0L ? blockProvider.getBlockContainer().getBlock(nextBlck, blockType) : null;
            ++index;
        }
        if (firstFreeIndex == -1) {
            firstFreeIndex = index;
        }
        this.blockIndexSequence.setFirstFreeIndex(firstFreeIndex == 0 ? 1 : firstFreeIndex);
        this.blockIndexSequence.markSequenceUsed();
    }

    public Block getBlockByIndex(int seqIndex) {
        this.checkOpened();
        return this.blockProvider.getBlockContainer().getBlock(this.blockIndexSequence.getBlockIndex(seqIndex), this.blockType);
    }

    public BlockIndexSequence getBlockIndexSequence() {
        return this.blockIndexSequence;
    }

    @Override
    public void close() {
        super.close();
        this.blockIndexSequence.close();
    }
}

