/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.seq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rostore.v2.media.Media;
import org.rostore.v2.seq.BlockIndexSequence;
import org.rostore.v2.seq.BlockSequence;
import org.rostore.v2.seq.SequenceBlock;

public class BlockIndexSequences {
    private static final Logger logger = Logger.getLogger(Media.class.getName());
    private final Map<Long, BlockIndexSequence> blockIndexSequences = new HashMap<Long, BlockIndexSequence>();
    private final Media media;

    public synchronized int size() {
        return this.blockIndexSequences.size();
    }

    public BlockIndexSequences(Media media) {
        this.media = media;
    }

    public synchronized <T extends SequenceBlock> BlockSequence<T> get(long startIndex, Function<BlockIndexSequence, BlockSequence<T>> factory) {
        BlockIndexSequence blockIndexSequence = this.blockIndexSequences.get(startIndex);
        if (blockIndexSequence != null) {
            return factory.apply(blockIndexSequence);
        }
        BlockSequence<T> blockSequence = factory.apply(null);
        this.blockIndexSequences.put(blockSequence.getBlockIndexSequence().getBlockIndex(0), blockSequence.getBlockIndexSequence());
        return blockSequence;
    }

    public synchronized void closeExpired() {
        long currentTime = System.currentTimeMillis();
        List<Long> blockSeqIdsToRemove = this.filter(bis -> bis.isSequenceInUse() || currentTime - bis.getLastUsageTimestampMillis() < this.media.getMediaProperties().getCloseUnusedSequencesAfterMillis());
        if (!blockSeqIdsToRemove.isEmpty()) {
            logger.log(Level.FINE, "Removed expired block sequences: " + blockSeqIdsToRemove.size());
        }
    }

    public List<Long> filter(Function<BlockIndexSequence, Boolean> filter) {
        ArrayList<Long> blockSeqIdsToRemove = new ArrayList<Long>();
        for (Map.Entry<Long, BlockIndexSequence> entry : this.blockIndexSequences.entrySet()) {
            if (filter.apply(entry.getValue()).booleanValue()) continue;
            blockSeqIdsToRemove.add(entry.getKey());
        }
        Iterator<Map.Entry<Long, BlockIndexSequence>> iterator = blockSeqIdsToRemove.iterator();
        while (iterator.hasNext()) {
            long id = (Long)((Object)iterator.next());
            this.blockIndexSequences.remove(id);
        }
        return blockSeqIdsToRemove;
    }
}

