/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.seq;

import java.util.ArrayList;
import java.util.List;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockIndices;

public class BlockIndexSequence
implements AutoCloseable {
    private final List<Long> sequenceBlockIndices = new ArrayList<Long>();
    private int refs = 0;
    private long lastUsageTimestampMillis = 0L;
    private int firstFreeIndex = -1;

    public void removeAtEnd(int howMany) {
        while (howMany != 0) {
            this.sequenceBlockIndices.remove(this.sequenceBlockIndices.size() - 1);
            --howMany;
        }
    }

    public CatalogBlockIndices createCatalogBlockIndices() {
        CatalogBlockIndices catalogBlockIndices = new CatalogBlockIndices();
        for (long blockIndex : this.sequenceBlockIndices) {
            catalogBlockIndices.add(blockIndex, blockIndex);
        }
        return catalogBlockIndices;
    }

    public void markSequenceUsed() {
        this.lastUsageTimestampMillis = System.currentTimeMillis();
        ++this.refs;
    }

    @Override
    public void close() {
        if (this.refs == 0) {
            throw new RoStoreException("Number of block sequence ref is negative");
        }
        --this.refs;
    }

    public boolean isSequenceInUse() {
        return this.refs > 0;
    }

    public long getBlockIndex(int seqIndex) {
        return this.sequenceBlockIndices.get(seqIndex);
    }

    public int length() {
        return this.sequenceBlockIndices.size();
    }

    public int getFreeBlockNumber() {
        return this.length() - this.getFirstFreeIndex();
    }

    public void add(int seqIndex, long blockIndex) {
        this.sequenceBlockIndices.add(seqIndex, blockIndex);
    }

    public void remove(int seqIndex) {
        this.sequenceBlockIndices.remove(seqIndex);
    }

    public long getLastUsageTimestampMillis() {
        return this.lastUsageTimestampMillis;
    }

    public int getFirstFreeIndex() {
        return this.firstFreeIndex;
    }

    public void setFirstFreeIndex(int firstFreeIndex) {
        if (firstFreeIndex > this.sequenceBlockIndices.size()) {
            throw new RoStoreException("Can't set the first index=\"" + firstFreeIndex + "\" when the sequence size=\"" + this.sequenceBlockIndices.size() + "\"");
        }
        this.firstFreeIndex = firstFreeIndex;
    }
}

