/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block.allocator;

import java.util.HashMap;
import java.util.Map;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.catalog.CatalogBlockIndicesIterator;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.allocator.BlockAllocatorListener;

public class BlockVerifierListener
implements BlockAllocatorListener {
    private final Map<String, Map<Long, BlockType>> allocated;

    public BlockVerifierListener() {
        this.allocated = new HashMap<String, Map<Long, BlockType>>();
    }

    private BlockVerifierListener(Map<String, Map<Long, BlockType>> allocated) {
        this.allocated = allocated;
    }

    public BlockVerifierListener snapshot() {
        HashMap<String, Map<Long, BlockType>> copy = new HashMap<String, Map<Long, BlockType>>();
        for (Map.Entry<String, Map<Long, BlockType>> entry : this.allocated.entrySet()) {
            HashMap<Long, BlockType> b = new HashMap<Long, BlockType>();
            copy.put(entry.getKey(), b);
            for (Map.Entry<Long, BlockType> entry2 : entry.getValue().entrySet()) {
                b.put(entry2.getKey(), entry2.getValue());
            }
        }
        return new BlockVerifierListener(copy);
    }

    @Override
    public synchronized void blocksFreed(String name, CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        Map<Long, BlockType> all = this.allocated.get(name);
        CatalogBlockIndicesIterator iterator = catalogBlockIndices.iterator();
        while (iterator.isValid()) {
            long id = iterator.get();
            if (all.remove(id) != null) continue;
            boolean bl = false;
        }
        if (all.isEmpty()) {
            this.allocated.remove(name);
        }
    }

    @Override
    public synchronized void blocksAllocated(String name, BlockType blockType, CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        Map<Long, BlockType> all = this.allocated.get(name);
        if (all == null) {
            all = new HashMap<Long, BlockType>();
            this.allocated.put(name, all);
        }
        CatalogBlockIndicesIterator iterator = catalogBlockIndices.iterator();
        while (iterator.isValid()) {
            long id = iterator.get();
            if (all.get(id) != null) {
                boolean bl = false;
            }
            all.put(id, blockType);
        }
    }
}

