/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block.allocator;

import java.util.ArrayList;
import java.util.List;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.allocator.BlockAllocatorListener;

public class BlockAllocatorListeners {
    private final List<BlockAllocatorListener> blockAllocatorListeners = new ArrayList<BlockAllocatorListener>();

    public void addListener(BlockAllocatorListener blockAllocatorListener) {
        this.blockAllocatorListeners.add(blockAllocatorListener);
    }

    public void removeListener(BlockAllocatorListener blockAllocatorListener) {
        this.blockAllocatorListeners.remove(blockAllocatorListener);
    }

    public boolean isEnabled() {
        return !this.blockAllocatorListeners.isEmpty();
    }

    public void notifyAllocated(String name, BlockType blockType, CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        for (BlockAllocatorListener listener : this.blockAllocatorListeners) {
            listener.blocksAllocated(name, blockType, catalogBlockIndices, rebalance);
        }
    }

    public void notifyFreed(String name, CatalogBlockIndices catalogBlockIndices, boolean rebalance) {
        for (BlockAllocatorListener listener : this.blockAllocatorListeners) {
            listener.blocksFreed(name, catalogBlockIndices, rebalance);
        }
    }
}

