/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.MappedPhysicalBlock;
import org.rostore.v2.media.block.container.BlockContainer;

public class MappedPhysicalBlocks {
    private static final Logger logger = Logger.getLogger(Media.class.getName());
    private final Map<Long, MappedPhysicalBlock> active = new HashMap<Long, MappedPhysicalBlock>();
    private final Map<Long, MappedPhysicalBlock> passive = new LinkedHashMap<Long, MappedPhysicalBlock>();
    private final Media media;
    private int maxBlocks = 0;

    public MappedPhysicalBlocks(Media media) {
        this.media = media;
    }

    public int size() {
        return this.active.size() + this.passive.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block get(BlockContainer blockContainer, long index, BlockType blockType) {
        MappedPhysicalBlock mappedPhysicalBlock;
        MappedPhysicalBlocks mappedPhysicalBlocks = this;
        synchronized (mappedPhysicalBlocks) {
            mappedPhysicalBlock = this.active.get(index);
            if (mappedPhysicalBlock == null) {
                mappedPhysicalBlock = this.passive.remove(index);
                if (mappedPhysicalBlock == null) {
                    mappedPhysicalBlock = new MappedPhysicalBlock(index, blockType);
                    int nextSize = this.size() + 1;
                    if (nextSize > this.maxBlocks) {
                        this.maxBlocks = nextSize;
                        if (this.maxBlocks % 10000 == 0) {
                            logger.log(Level.INFO, "Max number of physical blocks has been changed, maxBlocks={0}", this.maxBlocks);
                        }
                    }
                } else {
                    mappedPhysicalBlock.setBlockType(blockType);
                }
                this.active.put(index, mappedPhysicalBlock);
            } else if (!blockType.equals((Object)mappedPhysicalBlock.getBlockType())) {
                ArrayList<Integer> containerIds = new ArrayList<Integer>(mappedPhysicalBlock.getAllContainerIds());
                StringBuilder sb = new StringBuilder("Incompatible block (");
                sb.append(index);
                sb.append(") types: assigned=");
                sb.append((Object)mappedPhysicalBlock.getBlockType());
                if (!containerIds.isEmpty()) {
                    sb.append(" in containers={");
                    for (int i = 0; i < containerIds.size(); ++i) {
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(containerIds.get(0));
                        sb.append("(");
                        sb.append((Object)this.media.getBlockContainer((Integer)containerIds.get(0)).getStatus());
                        sb.append(")");
                    }
                    sb.append("}");
                }
                sb.append(", requested=");
                sb.append((Object)blockType);
                throw new RoStoreException(sb.toString());
            }
            mappedPhysicalBlock.markAsUsed(blockContainer);
        }
        return mappedPhysicalBlock.get(blockContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BlockContainer blockContainer, long index) {
        MappedPhysicalBlock mappedPhysicalBlock;
        MappedPhysicalBlocks mappedPhysicalBlocks = this;
        synchronized (mappedPhysicalBlocks) {
            mappedPhysicalBlock = this.active.get(index);
        }
        if (mappedPhysicalBlock != null) {
            mappedPhysicalBlock.flush();
            mappedPhysicalBlocks = this;
            synchronized (mappedPhysicalBlocks) {
                mappedPhysicalBlock.remove(blockContainer);
                if (!mappedPhysicalBlock.inUse()) {
                    this.active.remove(index);
                    if (!BlockType.DATA.equals((Object)mappedPhysicalBlock.getBlockType())) {
                        this.passive.put(index, mappedPhysicalBlock);
                    }
                }
            }
        } else {
            throw new RoStoreException("Removing a non-active block " + index + " from container " + blockContainer.getContainerId());
        }
    }

    public synchronized void closeExpired() {
        long currentTime = System.currentTimeMillis();
        ArrayList<Long> blockIdsToRemove = new ArrayList<Long>();
        for (Map.Entry<Long, MappedPhysicalBlock> entry : this.passive.entrySet()) {
            if (currentTime - entry.getValue().getUnusedSince() <= this.media.getMediaProperties().getCloseUnusedBlocksAfterMillis()) continue;
            blockIdsToRemove.add(entry.getKey());
        }
        blockIdsToRemove.forEach(id -> this.passive.remove(id));
        if (!blockIdsToRemove.isEmpty()) {
            logger.log(Level.FINE, "Removed expired physical blocks: {0} ", blockIdsToRemove.size());
        }
    }

    public synchronized void closeUnused() {
        this.passive.clear();
    }
}

