/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block;

import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.container.BlockContainer;

public class BlockProviderImpl
implements BlockProvider {
    private BlockAllocator blockAllocator;
    private BlockContainer blockContainer;

    @Override
    public BlockContainer getBlockContainer() {
        return this.blockContainer;
    }

    @Override
    public BlockAllocator getBlockAllocator() {
        return this.blockAllocator;
    }

    public void exchangeBlockAllocator(BlockAllocator blockAllocator) {
        this.blockAllocator = blockAllocator;
    }

    @Override
    public Media getMedia() {
        return this.blockContainer.getMedia();
    }

    public static BlockProviderImpl internal(BlockAllocator blockAllocator) {
        return new BlockProviderImpl(blockAllocator);
    }

    public static BlockProviderImpl internal(Media media) {
        return new BlockProviderImpl(media);
    }

    public static BlockProviderImpl external(BlockProvider blockProvider) {
        return new BlockProviderImpl(blockProvider);
    }

    private BlockProviderImpl(BlockAllocator blockAllocator) {
        this.blockAllocator = blockAllocator;
        this.blockContainer = blockAllocator.getMedia().newBlockContainer();
    }

    private BlockProviderImpl(Media media) {
        this.blockAllocator = null;
        this.blockContainer = media.newBlockContainer();
    }

    private BlockProviderImpl(BlockProvider blockProvider) {
        this.blockContainer = blockProvider.getBlockContainer();
        this.blockAllocator = blockProvider.getBlockAllocator();
    }
}

