/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media.block;

import java.nio.ByteBuffer;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.block.MappedPhysicalBlock;
import org.rostore.v2.media.block.container.BlockContainer;
import org.rostore.v2.media.block.container.Status;

public class Block
implements Committable {
    private final ByteBuffer content;
    private final MappedPhysicalBlock mappedPhysicalBlock;
    private final BlockContainer blockContainer;

    protected Block(ByteBuffer byteBuffer, MappedPhysicalBlock mappedPhysicalBlock, BlockContainer blockContainer) {
        this.content = byteBuffer;
        this.mappedPhysicalBlock = mappedPhysicalBlock;
        this.blockContainer = blockContainer;
    }

    protected MappedPhysicalBlock getAllocatedBlock() {
        return this.mappedPhysicalBlock;
    }

    protected void markDirty() {
        this.mappedPhysicalBlock.setDirty();
    }

    public void backLong() {
        this.content.position(this.content.position() - 8);
    }

    public void backInt() {
        this.content.position(this.content.position() - 4);
    }

    public void back(int bytesPerRecord) {
        this.content.position(this.content.position() - bytesPerRecord);
    }

    public void backBlockIndex() {
        this.content.position(this.content.position() - this.blockContainer.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
    }

    public long getAbsoluteIndex() {
        return this.mappedPhysicalBlock.getIndex();
    }

    public void position(int position) {
        this.content.position(position);
    }

    public void skip(int bytes) {
        this.content.position(this.content.position() + bytes);
    }

    public int position() {
        return this.content.position();
    }

    public int length() {
        return this.content.limit();
    }

    public int left() {
        return this.content.limit() - this.content.position();
    }

    public void putByte(byte b) {
        this.markDirty();
        this.content.put(b);
    }

    public void putLong(long l) {
        this.markDirty();
        this.content.putLong(l);
    }

    public void putInt(int i) {
        this.markDirty();
        this.content.putInt(i);
    }

    public void collapseWindow(int windowSize, int tailSize) {
        if (tailSize != 0) {
            this.markDirty();
            int startAt = this.content.position();
            int stopAt = startAt + tailSize;
            for (int i = startAt; i < stopAt; ++i) {
                this.content.put(i, this.content.get(i + windowSize));
            }
        }
    }

    public void insertWindows(int windowSize, int tailSize) {
        if (tailSize != 0) {
            this.markDirty();
            int startAt = this.content.position() + windowSize;
            int stopAt = startAt + tailSize;
            for (int i = stopAt - 1; i >= startAt; --i) {
                this.content.put(i, this.content.get(i - windowSize));
            }
        }
    }

    public void writeBlockIndex(long l) {
        this.putLong(l, this.blockContainer.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
    }

    public void putLong(long l, int bytesPerRecord) {
        if (bytesPerRecord != 0) {
            this.markDirty();
            for (int i = bytesPerRecord - 1; i >= 0; --i) {
                long shifted = l >> i * 8;
                byte b = (byte)(shifted & 0xFFL);
                this.content.put(b);
            }
        }
    }

    public void put(byte[] data, int offset, int length) {
        if (length != 0) {
            this.markDirty();
            this.content.put(data, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Block sourceBlock, int length) {
        if (length != 0) {
            this.markDirty();
            int oldLimit = sourceBlock.content.limit();
            int newLimit = sourceBlock.content.position() + length;
            if (newLimit > oldLimit) {
                throw new RoStoreException("Can't move beyond the block boundaries (" + newLimit + "(" + sourceBlock.content.position() + " + " + length + ")>" + oldLimit + ")");
            }
            sourceBlock.content.limit(newLimit);
            try {
                this.content.put(sourceBlock.content);
            }
            finally {
                sourceBlock.content.limit(oldLimit);
            }
        }
    }

    public int compare(byte[] data, int offset, int length) {
        int startPosition = this.content.position();
        for (int i = 0; i < length; ++i) {
            int res = data[i + offset] - this.content.get(i + startPosition);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public void get(byte[] data, int offset, int length) {
        if (length != 0) {
            this.content.get(data, offset, length);
        }
    }

    public long getLong(int bytesPerRecord) {
        long l = 0L;
        for (int i = 0; i < bytesPerRecord; ++i) {
            int b = this.content.get();
            l <<= 8;
            l |= (long)(b &= 0xFF);
        }
        return l;
    }

    public long readBlockIndex() {
        return this.getLong(this.blockContainer.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
    }

    public byte getByte() {
        return this.content.get();
    }

    public long getLong() {
        return this.content.getLong();
    }

    public int getInt() {
        return this.content.getInt();
    }

    public void clean() {
        this.markDirty();
        this.content.position(0);
        while (this.content.position() < this.content.limit()) {
            this.content.put((byte)0);
        }
        this.content.position(0);
    }

    public String toString() {
        return "Block: index=" + this.getAbsoluteIndex() + " pos=" + this.position() + " " + (this.mappedPhysicalBlock.isDirty() ? "dirty" : "");
    }

    @Override
    public void close() {
        this.blockContainer.evict(this);
    }

    @Override
    public Status getStatus() {
        return this.blockContainer.hasBlock(this.getAbsoluteIndex()) ? Status.OPENED : Status.CLOSED;
    }

    @Override
    public void commit() {
        this.mappedPhysicalBlock.flush();
    }
}

