/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media;

import org.rostore.Utils;
import org.rostore.entity.media.MediaPropertiesBuilder;
import org.rostore.mapper.MapperProperties;

public class MediaProperties {
    private long maxTotalSize;
    private int blockSize;
    private long totalBlockNumber;
    private long closeUnusedBlocksAfterMillis;
    private long closeUnusedSequencesAfterMillis;
    private MapperProperties mapperProperties;

    public static MediaProperties from(MediaPropertiesBuilder builder) {
        MediaProperties mediaProperties = new MediaProperties();
        mediaProperties.maxTotalSize = builder.getMaxTotalSize();
        mediaProperties.blockSize = builder.getBlockSize();
        mediaProperties.totalBlockNumber = mediaProperties.maxTotalSize / (long)mediaProperties.blockSize;
        mediaProperties.closeUnusedSequencesAfterMillis = builder.getCloseUnusedSequencesAfterMillis();
        mediaProperties.closeUnusedBlocksAfterMillis = builder.getCloseUnusedBlocksAfterMillis();
        MapperProperties mapperProperties = new MapperProperties();
        mapperProperties.setBytesPerBlockIndex(Utils.computeBytesForMaxValue((long)(builder.getMaxTotalSize() / (long)builder.getBlockSize() + 1L)));
        mapperProperties.setBytesPerBlockOffset(Utils.computeBytesForMaxValue((long)(builder.getBlockSize() - 1)));
        mediaProperties.mapperProperties = mapperProperties;
        return mediaProperties;
    }

    public long getTotalBlockNumber() {
        return this.totalBlockNumber;
    }

    public long getMaxTotalSize() {
        return this.maxTotalSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getCloseUnusedBlocksAfterMillis() {
        return this.closeUnusedBlocksAfterMillis;
    }

    public long getCloseUnusedSequencesAfterMillis() {
        return this.closeUnusedSequencesAfterMillis;
    }

    public MapperProperties getMapperProperties() {
        return this.mapperProperties;
    }
}

