/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.media;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rostore.entity.MemoryAllocation;
import org.rostore.entity.RoStoreException;
import org.rostore.entity.media.MediaPropertiesBuilder;
import org.rostore.mapper.BinaryMapper;
import org.rostore.v2.data.DataReader;
import org.rostore.v2.data.DataWriter;
import org.rostore.v2.media.MediaHeader;
import org.rostore.v2.media.MediaProperties;
import org.rostore.v2.media.MemoryConsumption;
import org.rostore.v2.media.RootClosableImpl;
import org.rostore.v2.media.block.MappedPhysicalBlocks;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.allocator.BlockAllocatorListeners;
import org.rostore.v2.media.block.allocator.RootBlockAllocator;
import org.rostore.v2.media.block.allocator.SecondaryBlockAllocator;
import org.rostore.v2.media.block.container.BlockContainer;
import org.rostore.v2.seq.BlockIndexSequences;

public class Media
extends RootClosableImpl {
    private static final Logger logger = Logger.getLogger(Media.class.getName());
    public static final byte MAGIC = 119;
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final MappedPhysicalBlocks mappedPhysicalBlocks;
    private final BlockIndexSequences blockIndexSequences;
    private Map<Integer, BlockContainer> blockContainers = new HashMap<Integer, BlockContainer>();
    private BlockAllocator rootBlockAllocator;
    private int blockContainerCount = 0;
    private MediaProperties mediaProperties;
    private BlockAllocatorListeners blockAllocatorListeners = new BlockAllocatorListeners();

    public BlockAllocatorListeners getBlockAllocatorListeners() {
        return this.blockAllocatorListeners;
    }

    public MediaProperties getMediaProperties() {
        return this.mediaProperties;
    }

    public BlockAllocator getBlockAllocator() {
        return this.rootBlockAllocator;
    }

    public MemoryConsumption getMemoryConsumption() {
        return new MemoryConsumption(this.mappedPhysicalBlocks.size(), this.blockIndexSequences.size(), this.blockContainers.size());
    }

    public BlockIndexSequences getBlockIndexSequences() {
        return this.blockIndexSequences;
    }

    public MappedPhysicalBlocks getMappedPhysicalBlocks() {
        return this.mappedPhysicalBlocks;
    }

    @Override
    public void close() {
        super.close();
        this.rootBlockAllocator.close();
        try {
            this.randomAccessFile.close();
        }
        catch (IOException ioException) {
            throw new RoStoreException("Can't close " + String.valueOf(this.file));
        }
    }

    public MemoryAllocation getMemoryManagement() {
        return this.rootBlockAllocator.getBlockAllocatorInternal().getMemoryAllocation();
    }

    protected Media(File file, MediaProperties mediaProperties, BiConsumer<Media, DataWriter> headerStream) {
        logger.log(Level.INFO, "Create a new media @" + String.valueOf(file));
        this.mediaProperties = mediaProperties;
        this.mappedPhysicalBlocks = new MappedPhysicalBlocks(this);
        this.blockIndexSequences = new BlockIndexSequences(this);
        this.file = file;
        if (mediaProperties.getMapperProperties().getBytesPerBlockIndex() > 8) {
            throw new RoStoreException("The maximum number of bytes for block index is 8, provided " + mediaProperties.getMapperProperties().getBytesPerBlockIndex());
        }
        try {
            this.randomAccessFile = new RandomAccessFile(file, "rw");
            this.randomAccessFile.setLength(mediaProperties.getMaxTotalSize());
            this.rootBlockAllocator = RootBlockAllocator.create(this);
            try (DataWriter dataWriter = DataWriter.open(this.rootBlockAllocator, 0L);){
                MediaHeader mediaHeader = new MediaHeader();
                mediaHeader.setMagic((byte)119);
                mediaHeader.setBlockSize(mediaProperties.getBlockSize());
                mediaHeader.setMaxTotalSize(mediaProperties.getMaxTotalSize());
                mediaHeader.setCloseUnusedBlocksAfterMillis(mediaProperties.getCloseUnusedBlocksAfterMillis());
                mediaHeader.setCloseUnusedSequencesAfterMillis(mediaProperties.getCloseUnusedSequencesAfterMillis());
                dataWriter.writeObject(mediaHeader);
                if (headerStream != null) {
                    headerStream.accept(this, dataWriter);
                }
            }
        }
        catch (IOException e) {
            throw new RoStoreException("Can't open " + String.valueOf(file), e);
        }
    }

    public void closeExpired() {
        this.blockIndexSequences.closeExpired();
        this.mappedPhysicalBlocks.closeExpired();
    }

    protected Media(File file, BiConsumer<Media, DataReader> headerStream) {
        logger.log(Level.INFO, "Opening media @" + String.valueOf(file));
        this.file = file;
        this.mappedPhysicalBlocks = new MappedPhysicalBlocks(this);
        this.blockIndexSequences = new BlockIndexSequences(this);
        try {
            this.randomAccessFile = new RandomAccessFile(file, "rw");
            byte[] head = new byte[13];
            this.randomAccessFile.read(head);
            MediaHeader mediaHeaderShort = (MediaHeader)BinaryMapper.deserialize(null, MediaHeader.class, (InputStream)new ByteArrayInputStream(head), (int)2);
            MediaPropertiesBuilder mediaPropertiesBuilder = new MediaPropertiesBuilder();
            mediaPropertiesBuilder.setBlockSize(mediaHeaderShort.getBlockSize());
            mediaPropertiesBuilder.setMaxTotalSize(mediaHeaderShort.getMaxTotalSize());
            this.mediaProperties = MediaProperties.from(mediaPropertiesBuilder);
            this.rootBlockAllocator = RootBlockAllocator.load(this);
            try (DataReader dataReader = DataReader.open(this, 0L);){
                MediaHeader mediaHeader = dataReader.readObject(MediaHeader.class);
                if (119 != mediaHeader.getMagic()) {
                    throw new RoStoreException("File " + String.valueOf(file) + " has a wrong structure");
                }
                mediaPropertiesBuilder.setCloseUnusedBlocksAfterMillis(mediaHeader.getCloseUnusedBlocksAfterMillis());
                mediaPropertiesBuilder.setCloseUnusedSequencesAfterMillis(mediaHeader.getCloseUnusedSequencesAfterMillis());
                this.mediaProperties = MediaProperties.from(mediaPropertiesBuilder);
                if (headerStream != null) {
                    headerStream.accept(this, dataReader);
                }
            }
        }
        catch (IOException e) {
            throw new RoStoreException("Can't open " + String.valueOf(file), e);
        }
    }

    public static Media create(File file, MediaProperties mediaProperties) {
        return Media.create(file, mediaProperties, (BiConsumer<Media, DataWriter>)null);
    }

    public static <T> Media create(File file, MediaProperties mediaProperties, Function<Media, T> headerFactory) {
        return Media.create(file, mediaProperties, (Media m, DataWriter dataWriter) -> dataWriter.writeObject(headerFactory.apply((Media)m)));
    }

    public static Media create(File file, MediaProperties mediaProperties, BiConsumer<Media, DataWriter> headerStream) {
        Media media = new Media(file, mediaProperties, headerStream);
        return media;
    }

    public static Media open(File file) {
        return Media.open(file, null);
    }

    public static <T> Media open(File file, Class<T> headerClass, BiConsumer<Media, T> header) {
        return Media.open(file, (m, dataReader) -> header.accept((Media)m, dataReader.readObject(headerClass)));
    }

    public static Media open(File file, BiConsumer<Media, DataReader> headerStream) {
        Media media = new Media(file, headerStream);
        return media;
    }

    public MappedByteBuffer map(long index) {
        long startOffset = index * (long)this.mediaProperties.getBlockSize();
        try {
            return this.randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, startOffset, this.mediaProperties.getBlockSize());
        }
        catch (IOException ioException) {
            throw new RoStoreException("Can't map " + String.valueOf(this.file) + " from " + startOffset + "(index=" + index + "), length=" + this.mediaProperties.getBlockSize(), ioException);
        }
    }

    public synchronized BlockContainer newBlockContainer() {
        int blockContainerId = this.blockContainerCount++;
        BlockContainer blockContainer = new BlockContainer(this, blockContainerId);
        this.blockContainers.put(blockContainerId, blockContainer);
        return blockContainer;
    }

    public synchronized BlockContainer getBlockContainer(int blockContainerId) {
        return this.blockContainers.get(blockContainerId);
    }

    public synchronized void freeBlockContainer(int blockContainerId) {
        this.blockContainers.remove(blockContainerId);
    }

    public synchronized BlockAllocator createSecondaryBlockAllocator(String allocatorName, long upperBlockNumberLimit) {
        return SecondaryBlockAllocator.create(allocatorName, this.rootBlockAllocator, upperBlockNumberLimit);
    }

    public synchronized BlockAllocator loadSecondaryBlockAllocator(String allocatorName, long startIndex, long upperBlockNumberLimit) {
        return SecondaryBlockAllocator.load(allocatorName, this.rootBlockAllocator, startIndex, upperBlockNumberLimit);
    }

    public synchronized void removeSecondaryBlockAllocator(BlockAllocator blockAllocator) {
        blockAllocator.remove();
    }

    public void dump() {
        this.rootBlockAllocator.getBlockAllocatorInternal().dump();
    }
}

