/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.keys;

import org.rostore.Utils;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.keys.VarSizeBlock;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockType;

public class VarSizeMultiBlock {
    public static final int MAX_STRING_KEY_REPRESENTATION = 50;
    private long currentBlockIndex;
    private int index;
    private final VarSizeBlock root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Block block = this.root.getBlock();
        int oldPosition = block.position();
        try {
            if (this.root.isMultiBlock()) {
                long size = this.getDataSize();
                long representationSize = size;
                if (representationSize > 50L) {
                    representationSize = 50L;
                }
                String content = this.toString((int)representationSize);
                String nx = this.getNextBlockIndex() == 0L ? " x" : " nx " + this.getNextBlockIndex();
                String string = "MultiBlock: sz " + size + nx + " d " + content;
                return string;
            }
            String string = "MutliBlock: invalid";
            return string;
        }
        finally {
            block.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(int length) {
        long prevBlockIndex = this.currentBlockIndex;
        int prevIndex = this.index;
        try {
            int dataLength;
            this.root();
            long dataSize = this.getDataSize();
            if (length < 0 || (long)length > dataSize) {
                length = (int)dataSize;
            }
            byte[] data = new byte[length];
            this.root();
            for (int current = 0; current != length; current += dataLength) {
                Block block = this.getBlock();
                dataLength = this.getBlockDataSize();
                if (current + dataLength > length) {
                    dataLength = length - current;
                }
                block.position(this.getHeaderSize());
                block.get(data, current, dataLength);
                if (this.next()) continue;
                break;
            }
            String string = new String(data) + (dataSize > (long)length ? "..." : "");
            return string;
        }
        finally {
            this.currentBlockIndex = prevBlockIndex;
            this.index = prevIndex;
        }
    }

    protected VarSizeMultiBlock(VarSizeBlock root) {
        this.root = root;
        this.currentBlockIndex = root.valid() ? root.getBlock().getAbsoluteIndex() : -1L;
    }

    public long getNextBlockIndex() {
        Block block = this.getBlock();
        block.position(this.root.getBlockIndex() == this.currentBlockIndex ? 1 : 0);
        return block.getLong(this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
    }

    public void free() {
        this.root();
        long nextBlock = this.getNextBlockIndex();
        int nextIndex = this.index + 1;
        this.root.getBlockProvider().freeBlock(this.currentBlockIndex);
        while (nextBlock != 0L) {
            this.currentBlockIndex = nextBlock;
            this.index = nextIndex++;
            nextBlock = this.getNextBlockIndex();
            this.root.getBlockProvider().freeBlock(this.currentBlockIndex);
        }
    }

    public boolean next() {
        long nextBlockIndex = this.getNextBlockIndex();
        if (nextBlockIndex == 0L) {
            return false;
        }
        ++this.index;
        this.currentBlockIndex = nextBlockIndex;
        return true;
    }

    public Block getBlock() {
        return this.root.getBlockProvider().getBlockContainer().getBlock(this.currentBlockIndex, BlockType.KEY);
    }

    public int getHeaderSize() {
        if (this.isRoot()) {
            return this.root.getHeaderSize();
        }
        return this.root.getBlockProvider().getBlockContainer().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
    }

    public boolean isRoot() {
        return this.currentBlockIndex == this.root.getBlockIndex();
    }

    public int computeRootMultiBlockHeaderSize(long dataSize) {
        return Utils.computeBytesForMaxValue((long)dataSize) + this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + 1;
    }

    public int computeRootMultiBlockDataCapacity(long dataSize) {
        return this.root.getBlockProvider().getMedia().getMediaProperties().getBlockSize() - this.computeRootMultiBlockHeaderSize(dataSize);
    }

    public long getBlockNumber() {
        this.root();
        long number = 1L;
        while (this.next()) {
            ++number;
        }
        return number;
    }

    public void addIndices(CatalogBlockIndices catalogBlockIndices) {
        this.root();
        while (this.next()) {
            catalogBlockIndices.add(this.currentBlockIndex, this.currentBlockIndex);
        }
    }

    public long getDataSize() {
        Block rootBlock = this.root.getBlock();
        rootBlock.position(0);
        byte preamble = rootBlock.getByte();
        rootBlock.skip(this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        return rootBlock.getLong(preamble);
    }

    public long create(byte[] data) {
        Block rootBlock = this.root.getBlockProvider().allocateBlock(BlockType.KEY);
        byte preamble = (byte)Utils.computeBytesForMaxValue((long)data.length);
        rootBlock.putByte(preamble);
        rootBlock.putLong(0L, this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        rootBlock.putLong(data.length, preamble);
        int blockSize = this.root.getBlockProvider().getMedia().getMediaProperties().getBlockSize();
        int copy = blockSize - rootBlock.position();
        if (copy > data.length) {
            copy = data.length;
        }
        rootBlock.put(data, 0, copy);
        Block previousBlock = rootBlock;
        while (copy < data.length) {
            Block nextBlock = this.root.getBlockProvider().allocateBlock(BlockType.KEY);
            nextBlock.putLong(0L, this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
            if (previousBlock == rootBlock) {
                previousBlock.position(1);
            } else {
                previousBlock.position(0);
            }
            previousBlock.putLong(nextBlock.getAbsoluteIndex(), this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
            int offset = copy;
            copy = offset + blockSize - this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
            if (copy > data.length) {
                copy = data.length;
            }
            nextBlock.put(data, offset, copy - offset);
            previousBlock = nextBlock;
        }
        return rootBlock.getAbsoluteIndex();
    }

    public int getDataCapacity() {
        return this.root.getBlockProvider().getMedia().getMediaProperties().getBlockSize() - this.getHeaderSize();
    }

    public long getTotalDataSize() {
        Block block = this.root.getBlock();
        block.position(0);
        byte preamble = block.getByte();
        block.skip(this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        return block.getLong(preamble);
    }

    public int getBlockDataSize() {
        long totalSize = this.getTotalDataSize();
        int capacity = this.getDataCapacity();
        if (this.isRoot()) {
            if ((long)capacity < totalSize) {
                return capacity;
            }
            return (int)totalSize;
        }
        long restDataSize = totalSize - (long)this.root.getDataCapacity();
        long tailSize = restDataSize - (long)((this.index - 1) * capacity);
        if (tailSize > (long)capacity) {
            return capacity;
        }
        return (int)tailSize;
    }

    public int compare(byte[] data, int offset, int length) {
        Block block = this.getBlock();
        block.position(this.getHeaderSize());
        return block.compare(data, offset, length);
    }

    public void put(byte[] data, int offset, int length) {
        Block block = this.getBlock();
        block.position(this.getHeaderSize());
        block.put(data, offset, length);
    }

    public void get(byte[] data, int offset, int length) {
        Block block = this.getBlock();
        block.position(this.getHeaderSize());
        block.get(data, offset, length);
    }

    public void root() {
        this.currentBlockIndex = this.root.getBlockIndex();
        this.index = 0;
    }
}

