/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.keys;

import org.rostore.v2.keys.VarSizeBlock;
import org.rostore.v2.media.block.Block;

public class VarSizeEntry {
    private static final int MAX_STRING = 50;
    private final VarSizeBlock root;
    private int offset;
    private int entrySize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Block block = this.root.getBlock();
        int oldPosition = block.position();
        try {
            if (this.root.isMultiEntry()) {
                int representationSize = this.entrySize;
                if (this.entrySize > 50) {
                    representationSize = 50;
                }
                byte[] data = new byte[representationSize];
                block.position(this.offset);
                block.get(data, 0, data.length);
                Object content = new String(data);
                if (this.entrySize > 50) {
                    content = (String)content + "...";
                }
                String string = "VarSizeEntry: b " + block.getAbsoluteIndex() + " off " + this.offset + " sz " + this.entrySize + " d " + (String)content;
                return string;
            }
            String string = "VarSizeEntry: invalid";
            return string;
        }
        finally {
            block.position(oldPosition);
        }
    }

    public boolean isFirst() {
        return this.offset == this.root.getHeaderSize();
    }

    public boolean isLast() {
        if (this.offset <= 0) {
            return true;
        }
        return this.offset + this.entrySize == this.getTotalSize();
    }

    public int getEntrySize() {
        return this.entrySize;
    }

    public void setEntrySize(int entrySize) {
        this.entrySize = entrySize != -1 ? entrySize : this.getTotalSize() - this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public VarSizeEntry(VarSizeBlock root) {
        this.root = root;
    }

    public int getTotalSize() {
        return this.getDataLength() + this.root.getHeaderSize();
    }

    public int getDataLength() {
        Block block = this.root.getBlock();
        block.position(1);
        return (int)block.getLong(this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }

    public int getFreeSpace() {
        return this.getDataCapacity() - this.getDataLength();
    }

    public void incDataLength(long delta) {
        Block block = this.root.getBlock();
        block.position(1);
        long value = block.getLong(this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        block.back(this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        block.putLong(value += delta, this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }

    public int getDataCapacity() {
        return this.root.getDataCapacity();
    }

    public int compare(byte[] data) {
        int res;
        Block block = this.root.getBlock();
        block.position(this.offset);
        int len = data.length;
        if (len > this.entrySize) {
            len = this.entrySize;
        }
        if ((res = block.compare(data, 0, len)) == 0) {
            return data.length - this.entrySize;
        }
        return res;
    }

    public byte[] extract() {
        Block block = this.root.getBlock();
        block.position(this.offset);
        byte[] data = new byte[this.entrySize];
        block.get(data, 0, this.entrySize);
        return data;
    }

    public void insert(byte[] data) {
        Block block = this.root.getBlock();
        int windowSize = data.length;
        int tailSize = this.getTotalSize() - this.offset;
        block.position(this.offset);
        block.insertWindows(windowSize, tailSize);
        block.put(data, 0, data.length);
        this.incDataLength(windowSize);
    }

    public void expand(byte[] data) {
        Block block = this.root.getBlock();
        int dataSizeBefore = this.getTotalSize();
        block.position(dataSizeBefore);
        block.put(data, 0, data.length);
        this.incDataLength(data.length);
        this.offset = dataSizeBefore;
    }

    public void remove() {
        Block block = this.root.getBlock();
        int dataSizeBefore = this.getTotalSize();
        int tailSize = dataSizeBefore - this.offset - this.entrySize;
        block.position(this.offset);
        block.collapseWindow(this.entrySize, tailSize);
        this.incDataLength(-this.entrySize);
    }

    public void init(Block block) {
        block.position(0);
        byte preamble = 0;
        block.putByte(preamble);
        block.putLong(0L, this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        this.offset = this.root.computeHeaderSize(preamble);
    }

    public void split(Block block) {
        int newBlockSize = this.getTotalSize() - this.offset;
        block.position(0);
        block.putByte((byte)0);
        block.putLong(newBlockSize, this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        Block sourceBlock = this.root.getBlock();
        sourceBlock.position(this.offset);
        block.put(sourceBlock, newBlockSize);
        sourceBlock.position(1);
        sourceBlock.putLong(this.offset - this.root.getMultiEntryHeaderSize(), this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }

    public void split(Block block, byte[] data) {
        int moveSize = this.getTotalSize() - this.offset;
        int newBlockSize = moveSize + data.length;
        block.position(0);
        block.putByte((byte)0);
        block.putLong(newBlockSize, this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        block.put(data, 0, data.length);
        Block sourceBlock = this.root.getBlock();
        sourceBlock.position(this.offset);
        block.put(sourceBlock, moveSize);
        sourceBlock.position(1);
        sourceBlock.putLong(this.offset - this.root.getMultiEntryHeaderSize(), this.root.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }
}

