/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.keys;

import org.rostore.v2.keys.VarSizeEntry;
import org.rostore.v2.keys.VarSizeMultiBlock;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockType;

public class VarSizeBlock {
    private final VarSizeMultiBlock multiBlock;
    private final VarSizeEntry multiEntry;
    private long blockIndex;
    private final BlockProvider blockProvider;

    public boolean invalid() {
        return this.blockIndex == -1L;
    }

    public boolean valid() {
        return this.blockIndex != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.invalid()) {
            return "VarSizeBlock: invalid";
        }
        Block block = this.getBlock();
        int backPosition = block.position();
        try {
            if (this.isMultiBlock()) {
                String string = this.multiBlock.toString();
                return string;
            }
            String string = this.multiEntry.toString();
            return string;
        }
        finally {
            block.position(backPosition);
        }
    }

    public VarSizeMultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public VarSizeEntry getEntry() {
        return this.multiEntry;
    }

    public int computeHeaderSize(byte preamble) {
        if (preamble != 0) {
            return 1 + this.blockProvider.getBlockContainer().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + preamble;
        }
        return 1 + this.blockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset();
    }

    public BlockProvider getBlockProvider() {
        return this.blockProvider;
    }

    public int getMultiEntryHeaderSize() {
        return this.computeHeaderSize((byte)0);
    }

    public int getHeaderSize() {
        byte preamble = this.getPreamble();
        return this.computeHeaderSize(preamble);
    }

    protected byte getPreamble() {
        Block block = this.getBlock();
        block.position(0);
        return block.getByte();
    }

    public boolean isMultiBlock() {
        return this.getPreamble() != 0;
    }

    public boolean isMultiEntry() {
        return this.getPreamble() == 0;
    }

    public Block getBlock() {
        return this.blockProvider.getBlockContainer().getBlock(this.blockIndex, BlockType.KEY);
    }

    public long getBlockIndex() {
        return this.blockIndex;
    }

    public int getDataCapacity() {
        return this.blockProvider.getMedia().getMediaProperties().getBlockSize() - this.getHeaderSize();
    }

    public int compare(byte[] key) {
        if (this.isMultiBlock()) {
            int size;
            this.multiBlock.root();
            long dataSize = this.multiBlock.getDataSize();
            int offset = 0;
            do {
                int res;
                if (key.length < (size = this.multiBlock.getBlockDataSize()) + offset) {
                    size = key.length - offset;
                }
                if ((res = this.multiBlock.compare(key, offset, size)) == 0) continue;
                return res;
            } while (this.multiBlock.next() && (offset += size) < key.length && (long)offset < dataSize);
            return (int)((long)key.length - dataSize);
        }
        return this.multiEntry.compare(key);
    }

    public byte[] extract() {
        if (this.isMultiBlock()) {
            int size;
            this.multiBlock.root();
            int dataSize = (int)this.multiBlock.getDataSize();
            byte[] data = new byte[dataSize];
            int offset = 0;
            do {
                size = this.multiBlock.getBlockDataSize();
                this.multiBlock.get(data, offset, size);
            } while (this.multiBlock.next() && (offset += size) < dataSize);
            return data;
        }
        return this.multiEntry.extract();
    }

    public void moveTo(long blockIndex) {
        this.blockIndex = blockIndex;
    }

    public VarSizeBlock(BlockProvider blockProvider) {
        this.blockProvider = blockProvider;
        this.blockIndex = -1L;
        this.multiBlock = new VarSizeMultiBlock(this);
        this.multiEntry = new VarSizeEntry(this);
    }
}

