/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.keys;

import java.util.function.Function;
import org.rostore.entity.OptionMismatchException;
import org.rostore.entity.Record;
import org.rostore.entity.VersionMismatchException;
import org.rostore.entity.VersionMismatchInitException;
import org.rostore.entity.media.RecordOption;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.fixsize.FixSizeEntryBlock;
import org.rostore.v2.keys.KeyBlockEntry;
import org.rostore.v2.keys.KeyList;
import org.rostore.v2.keys.RecordLengths;
import org.rostore.v2.keys.VarSizeBlock;
import org.rostore.v2.keys.VarSizeEntry;
import org.rostore.v2.keys.VarSizeMultiBlock;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockProviderImpl;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.container.Status;
import org.rostore.v2.seq.BlockSequence;
import org.rostore.v2.seq.SequenceBlock;

public class KeyBlockOperations
implements Committable {
    private final FixSizeEntryBlock<KeyBlockEntry> keyBlock;
    private final VarSizeBlock varSizeBlock;
    private final VarSizeMultiBlock varSizeMultiBlock;
    private final VarSizeEntry varSizeEntry;
    private final KeyBlockEntry keyBlockEntry;
    private boolean rebalance = false;

    public BlockSequence getBlockSequence() {
        return this.keyBlock.getBlockSequence();
    }

    public void remove() {
        CatalogBlockIndices toFree = new CatalogBlockIndices();
        for (int i = 0; i < this.keyBlock.getBlockSequence().length(); ++i) {
            this.keyBlock.moveTo(i);
            for (int j = 0; j < this.keyBlock.getEntriesNumber(); ++j) {
                this.keyBlockEntry.moveTo(j);
                if (this.varSizeBlock.isMultiBlock()) {
                    this.varSizeMultiBlock.free();
                    continue;
                }
                if (toFree.contains(this.keyBlockEntry.getBlockIndex())) continue;
                toFree.add(this.keyBlockEntry.getBlockIndex(), this.keyBlockEntry.getBlockIndex());
            }
        }
        this.varSizeBlock.getBlockProvider().getBlockAllocator().free(toFree);
        this.varSizeBlock.getBlockProvider().getBlockAllocator().free(this.keyBlock.getBlockSequence().getBlockIndexSequence().createCatalogBlockIndices());
    }

    public void dump() {
        for (int i = 0; i < this.keyBlock.getBlockSequence().length(); ++i) {
            this.keyBlock.moveTo(i);
            System.out.println(this.keyBlock.getBlock().getAbsoluteIndex() + ": H" + this.keyBlock.getHeaderSize() + "E" + this.keyBlockEntry.getEntrySize() + "x" + this.keyBlock.getEntriesNumber());
            for (int j = 0; j < this.keyBlock.getEntriesNumber(); ++j) {
                this.keyBlockEntry.moveTo(j);
                System.out.println(" " + String.valueOf(this.keyBlockEntry) + " --> " + this.varSizeBlock.toString());
            }
        }
    }

    public static KeyBlockOperations load(BlockAllocator blockAllocator, long startIndex, RecordLengths recordLengths) {
        BlockProviderImpl blockProvider = BlockProviderImpl.internal(blockAllocator);
        return new KeyBlockOperations(blockProvider, kbo -> SequenceBlock.load(blockProvider, startIndex, sequence -> new FixSizeEntryBlock<KeyBlockEntry>((BlockSequence<FixSizeEntryBlock>)sequence, 0, b -> new KeyBlockEntry((FixSizeEntryBlock<KeyBlockEntry>)b, kbo.varSizeBlock, recordLengths), null), BlockType.KEY));
    }

    public static KeyBlockOperations create(BlockAllocator blockAllocator, RecordLengths recordLengths) {
        BlockProviderImpl blockProvider = BlockProviderImpl.internal(blockAllocator);
        return new KeyBlockOperations(blockProvider, kbo -> SequenceBlock.create(blockProvider, sequence -> new FixSizeEntryBlock<KeyBlockEntry>((BlockSequence<FixSizeEntryBlock>)sequence, 0, b -> new KeyBlockEntry((FixSizeEntryBlock<KeyBlockEntry>)b, kbo.varSizeBlock, recordLengths), null), BlockType.KEY));
    }

    public long getStartIndex() {
        return this.keyBlock.getBlockSequence().getBlockIndexSequence().getBlockIndex(0);
    }

    private KeyBlockOperations(BlockProvider blockProvider, Function<KeyBlockOperations, FixSizeEntryBlock<KeyBlockEntry>> keyBlockFactory) {
        this.varSizeBlock = new VarSizeBlock(blockProvider);
        this.varSizeEntry = this.varSizeBlock.getEntry();
        this.varSizeMultiBlock = this.varSizeBlock.getMultiBlock();
        this.keyBlock = keyBlockFactory.apply(this);
        this.keyBlockEntry = this.keyBlock.getEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeIfExpired(int blockIndex) {
        try {
            this.keyBlock.moveTo(blockIndex);
            if (this.keyBlock.invalid()) {
                long l = -1L;
                return l;
            }
            this.keyBlockEntry.sync(false);
            long currentTimeSecs = System.currentTimeMillis() / 1000L;
            try {
                this.keyBlockEntry.first();
                while (this.keyBlockEntry.valid() && !this.keyBlockEntry.isExpired(currentTimeSecs)) {
                    this.keyBlockEntry.next();
                }
            }
            finally {
                this.keyBlockEntry.sync(true);
            }
            if (this.keyBlockEntry.valid() && this.keyBlockEntry.isExpired(currentTimeSecs)) {
                long id = this.keyBlockEntry.getId();
                this.removeEntryInternally();
                long l = id;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.rebalance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(byte[] key, Record record) {
        try {
            int cmp;
            this.keyBlock.root();
            if (this.keyBlockEntry.valid()) {
                cmp = this.varSizeBlock.compare(key);
                if (cmp < 0) {
                    boolean bl = false;
                    return bl;
                }
                if (cmp == 0) {
                    boolean expired = this.keyBlockEntry.isExpired();
                    this.removeEntry(record);
                    boolean bl = !expired;
                    return bl;
                }
            } else {
                this.keyBlock.next();
                if (this.keyBlock.invalid()) {
                    boolean expired = false;
                    return expired;
                }
                cmp = this.varSizeBlock.compare(key);
                if (cmp == 0) {
                    boolean expired = this.keyBlockEntry.isExpired();
                    this.removeEntry(record);
                    boolean bl = !expired;
                    return bl;
                }
                if (cmp < 0) {
                    boolean expired = false;
                    return expired;
                }
            }
            this.keyBlock.last();
            this.keyBlockEntry.last();
            cmp = this.varSizeBlock.compare(key);
            if (cmp == 0) {
                boolean expired = this.keyBlockEntry.isExpired();
                this.removeEntry(record);
                boolean bl = !expired;
                return bl;
            }
            if (cmp > 0) {
                boolean expired = false;
                return expired;
            }
            cmp = this.findAfter(key);
            if (cmp == 0) {
                boolean expired = this.keyBlockEntry.isExpired();
                this.removeEntry(record);
                boolean bl = !expired;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rebalance();
        }
    }

    void removeEntry(Record record) {
        Record recordToRemove = this.keyBlockEntry.getRecord();
        if (!this.keyBlockEntry.isExpired()) {
            VersionMismatchException.checkAndThrow(recordToRemove.getVersion(), record.getVersion(), record.hasOption(RecordOption.OVERRIDE_VERSION));
        }
        this.removeEntryInternally();
        record.eol(recordToRemove.getEol());
        record.id(recordToRemove.getId());
    }

    void removeEntryInternally() {
        if (this.varSizeBlock.isMultiBlock()) {
            this.varSizeMultiBlock.free();
        } else if (this.varSizeEntry.getDataLength() == this.varSizeEntry.getEntrySize()) {
            this.varSizeBlock.getBlockProvider().freeBlock(this.varSizeBlock.getBlock().getAbsoluteIndex());
        } else {
            int size = this.varSizeEntry.getEntrySize();
            this.varSizeEntry.remove();
            long hash = this.keyBlockEntry.getHash();
            this.correctAfterInsert(-size);
            this.keyBlockEntry.moveToHash(hash);
        }
        this.removeKeyEntry();
    }

    private void removeKeyEntry() {
        if (this.keyBlock.getEntriesNumber() == 1) {
            if (this.keyBlock.isRoot()) {
                this.keyBlockEntry.remove();
            } else {
                this.keyBlock.delete();
                this.markToRebalance();
            }
        } else {
            this.keyBlockEntry.remove();
        }
    }

    private void markToRebalance() {
        this.rebalance = true;
    }

    private void rebalance() {
        if (this.rebalance) {
            this.keyBlock.getBlockSequence().rebalance();
            this.rebalance = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(byte[] key, Record record) {
        try {
            int cmp;
            this.keyBlock.root();
            if (this.keyBlockEntry.valid()) {
                cmp = this.varSizeBlock.compare(key);
                if (cmp < 0) {
                    OptionMismatchException.checkInsertRecord(record);
                    VersionMismatchInitException.checkAndThrow(record);
                    this.insertFirstEntry(key, record);
                    long l = -1L;
                    return l;
                }
                if (cmp == 0) {
                    long l = this.updateRecord(record);
                    return l;
                }
            } else {
                this.keyBlock.next();
                if (this.keyBlock.invalid()) {
                    this.keyBlock.root();
                    OptionMismatchException.checkInsertRecord(record);
                    VersionMismatchInitException.checkAndThrow(record);
                    this.insertFirstEntry(key, record);
                    long l = -1L;
                    return l;
                }
                cmp = this.varSizeBlock.compare(key);
                if (cmp < 0) {
                    this.keyBlock.root();
                    OptionMismatchException.checkInsertRecord(record);
                    VersionMismatchInitException.checkAndThrow(record);
                    this.insertFirstEntry(key, record);
                    long l = -1L;
                    return l;
                }
                if (cmp == 0) {
                    long l = this.updateRecord(record);
                    return l;
                }
            }
            this.keyBlock.last();
            this.keyBlockEntry.last();
            cmp = this.varSizeBlock.compare(key);
            if (cmp == 0) {
                long l = this.updateRecord(record);
                return l;
            }
            if (cmp > 0) {
                OptionMismatchException.checkInsertRecord(record);
                VersionMismatchInitException.checkAndThrow(record);
                this.expandLastEntry(key, record);
                long l = -1L;
                return l;
            }
            cmp = this.findAfter(key);
            if (cmp == 0) {
                long l = this.updateRecord(record);
                return l;
            }
            OptionMismatchException.checkInsertRecord(record);
            VersionMismatchInitException.checkAndThrow(record);
            this.insertBeforeEntry(key, record);
            long l = -1L;
            return l;
        }
        finally {
            this.rebalance();
        }
    }

    private long updateRecord(Record record) {
        Record previousRecord = this.keyBlockEntry.getRecord();
        if (this.keyBlockEntry.isExpired()) {
            OptionMismatchException.checkInsertRecord(record);
        } else {
            OptionMismatchException.checkUpdateRecord(this.keyBlockEntry, record);
        }
        if (!record.hasOption(RecordOption.OVERRIDE_VERSION)) {
            if (this.keyBlockEntry.isExpired()) {
                VersionMismatchInitException.checkAndThrow(record);
                record.incrementVersion(this.keyBlockEntry.getRecordLengths().getVersionLength());
            } else {
                VersionMismatchException.checkAndThrow(previousRecord.getVersion(), record);
                record.version(previousRecord.getVersion());
                record.incrementVersion(this.keyBlockEntry.getRecordLengths().getVersionLength());
            }
        }
        this.keyBlockEntry.setRecord(record);
        return previousRecord.getId();
    }

    private void insertFirstEntry(byte[] key, Record record) {
        if (this.shouldBeMultiBlock(key)) {
            long blockIndex = this.varSizeMultiBlock.create(key);
            this.insertKeyEntry(blockIndex, 0L, record);
        } else if (this.keyBlockEntry.invalid()) {
            this.insertSingleEntryBlock(key, record);
        } else if (this.varSizeBlock.isMultiBlock()) {
            this.insertSingleEntryBlock(key, record);
        } else if (this.varSizeEntry.getFreeSpace() > key.length) {
            this.varSizeEntry.insert(key);
            this.insertKeyEntry(this.varSizeBlock.getBlockIndex(), this.varSizeEntry.getOffset(), record);
            this.correctAfterInsert(key.length);
        } else {
            this.insertSingleEntryBlock(key, record);
        }
    }

    private void expandLastEntry(byte[] key, Record record) {
        if (this.shouldBeMultiBlock(key)) {
            long blockIndex = this.varSizeMultiBlock.create(key);
            this.expandKeyEntry(blockIndex, 0L, record);
        } else if (this.varSizeBlock.isMultiEntry()) {
            if (this.varSizeEntry.getFreeSpace() > key.length) {
                this.varSizeEntry.expand(key);
                this.expandKeyEntry(this.varSizeBlock.getBlockIndex(), this.varSizeEntry.getOffset(), record);
            } else {
                this.expandSingleEntryBlock(key, record);
            }
        } else {
            this.expandSingleEntryBlock(key, record);
        }
    }

    private boolean shouldBeMultiBlock(byte[] key) {
        int multiEntryCapacity = this.varSizeBlock.getBlockProvider().getBlockAllocator().getMedia().getMediaProperties().getBlockSize() - this.varSizeBlock.getMultiEntryHeaderSize();
        return key.length > multiEntryCapacity / 2;
    }

    private void insertBeforeEntry(byte[] key, Record record) {
        if (this.shouldBeMultiBlock(key)) {
            long blockIndex = this.varSizeMultiBlock.create(key);
            if (this.varSizeBlock.isMultiBlock()) {
                this.insertKeyEntry(blockIndex, 0L, record);
            } else if (this.varSizeEntry.isFirst()) {
                this.insertKeyEntry(blockIndex, 0L, record);
            } else {
                long hash = this.keyBlockEntry.getHash();
                Block nextBlock = this.varSizeBlock.getBlockProvider().allocateBlock(BlockType.KEY);
                this.varSizeEntry.split(nextBlock);
                this.correctAfterMove(nextBlock.getAbsoluteIndex(), 0L);
                this.keyBlockEntry.moveToHash(hash);
                this.insertKeyEntry(blockIndex, this.varSizeBlock.getMultiEntryHeaderSize(), record);
            }
        } else if (this.varSizeBlock.isMultiBlock()) {
            long afterHash = this.keyBlockEntry.getHash();
            this.previousEntry();
            if (this.varSizeBlock.isMultiEntry()) {
                if (this.varSizeEntry.getFreeSpace() >= key.length) {
                    this.varSizeEntry.expand(key);
                    long blockIndex = this.varSizeBlock.getBlockIndex();
                    long offset = this.varSizeEntry.getOffset();
                    this.keyBlockEntry.moveToHash(afterHash);
                    this.insertKeyEntry(blockIndex, offset, record);
                } else {
                    this.keyBlockEntry.moveToHash(afterHash);
                    this.insertSingleEntryBlock(key, record);
                }
            } else {
                this.keyBlockEntry.moveToHash(afterHash);
                this.insertSingleEntryBlock(key, record);
            }
        } else if (this.varSizeEntry.getFreeSpace() >= key.length) {
            int offset = this.varSizeEntry.getOffset();
            this.varSizeEntry.insert(key);
            this.insertKeyEntry(this.varSizeBlock.getBlockIndex(), offset, record);
            this.correctAfterInsert(key.length);
        } else {
            long hash = this.keyBlockEntry.getHash();
            if (this.varSizeEntry.isFirst()) {
                this.previousEntry();
                if (this.keyBlockEntry.valid()) {
                    if (this.varSizeBlock.isMultiEntry() && this.varSizeEntry.getFreeSpace() >= key.length) {
                        this.varSizeEntry.expand(key);
                        long blockIndex = this.varSizeBlock.getBlock().getAbsoluteIndex();
                        long offset = this.varSizeEntry.getOffset();
                        this.keyBlockEntry.moveToHash(hash);
                        this.insertKeyEntry(blockIndex, offset, record);
                        return;
                    }
                    Block betweenBlock = this.varSizeBlock.getBlockProvider().allocateBlock(BlockType.KEY);
                    this.varSizeEntry.init(betweenBlock);
                    this.varSizeBlock.moveTo(betweenBlock.getAbsoluteIndex());
                    this.varSizeEntry.expand(key);
                    this.keyBlockEntry.moveToHash(hash);
                    this.insertKeyEntry(betweenBlock.getAbsoluteIndex(), this.varSizeEntry.getOffset(), record);
                    return;
                }
            }
            this.keyBlockEntry.moveToHash(hash);
            long offset = this.keyBlockEntry.getBlockOffset();
            long blockIndex = this.keyBlockEntry.getBlockIndex();
            Block nextBlock = this.varSizeBlock.getBlockProvider().allocateBlock(BlockType.KEY);
            long spaceBeFreed = (long)this.varSizeBlock.getBlockProvider().getBlockContainer().getMedia().getMediaProperties().getBlockSize() - offset;
            if (spaceBeFreed > (long)key.length) {
                this.varSizeEntry.split(nextBlock);
                this.varSizeEntry.expand(key);
                this.correctAfterMove(nextBlock.getAbsoluteIndex(), 0L);
                this.keyBlockEntry.moveToHash(hash);
                this.insertKeyEntry(blockIndex, offset, record);
            } else {
                this.varSizeEntry.split(nextBlock, key);
                this.correctAfterMove(nextBlock.getAbsoluteIndex(), key.length);
                this.keyBlockEntry.moveToHash(hash);
                this.insertKeyEntry(nextBlock.getAbsoluteIndex(), this.varSizeBlock.getMultiEntryHeaderSize(), record);
            }
        }
    }

    private void previousEntry() {
        this.keyBlockEntry.previous();
        if (this.keyBlockEntry.invalid()) {
            this.keyBlock.previous();
            this.keyBlockEntry.last();
        }
    }

    private void fillNewKeyEntry(long blockIndex, long blockOffset, Record record) {
        this.keyBlockEntry.setBlockIndex(blockIndex);
        this.keyBlockEntry.setBlockOffset(blockOffset);
        if (!record.hasOption(RecordOption.OVERRIDE_VERSION)) {
            record.incrementVersion(this.keyBlockEntry.getRecordLengths().getVersionLength());
        }
        this.keyBlockEntry.setRecord(record);
    }

    private void insertSingleEntryBlock(byte[] key, Record record) {
        Block newBlock = this.varSizeBlock.getBlockProvider().allocateBlock(BlockType.KEY);
        if (!this.varSizeEntry.isLast()) {
            this.varSizeBlock.moveTo(newBlock.getAbsoluteIndex());
        }
        this.varSizeEntry.init(newBlock);
        this.insertKeyEntry(newBlock.getAbsoluteIndex(), this.varSizeBlock.getMultiEntryHeaderSize(), record);
        this.varSizeEntry.expand(key);
    }

    private void expandSingleEntryBlock(byte[] key, Record record) {
        Block newBlock = this.varSizeBlock.getBlockProvider().allocateBlock(BlockType.KEY);
        this.varSizeEntry.init(newBlock);
        this.expandKeyEntry(newBlock.getAbsoluteIndex(), this.varSizeBlock.getMultiEntryHeaderSize(), record);
        this.keyBlockEntry.sync(true);
        this.varSizeEntry.expand(key);
    }

    private void correctAfterMove(long newBlockIndex, long newLocationOffset) {
        long correction = (long)(-this.varSizeEntry.getOffset() + this.varSizeBlock.getMultiEntryHeaderSize()) + newLocationOffset;
        long oldBlockIndex = this.keyBlockEntry.getBlockIndex();
        while (this.keyBlockEntry.valid() && this.keyBlockEntry.getBlockIndex() == oldBlockIndex) {
            this.keyBlockEntry.setBlockIndex(newBlockIndex);
            this.keyBlockEntry.incBlockOffset(correction);
            this.nextKeyEntry();
        }
    }

    private void correctAfterInsert(long size) {
        long blockIndex = this.keyBlockEntry.getBlockIndex();
        this.nextKeyEntry();
        while (this.keyBlockEntry.valid() && this.keyBlockEntry.getBlockIndex() == blockIndex) {
            this.keyBlockEntry.incBlockOffset(size);
            this.nextKeyEntry();
        }
    }

    private void nextKeyEntry() {
        this.keyBlockEntry.next();
        if (this.keyBlockEntry.invalid()) {
            this.keyBlock.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandKeyEntry(long blockIndex, long offset, Record record) {
        boolean syncBefore = this.keyBlockEntry.sync(false);
        try {
            if (this.keyBlock.hasFreeSpace()) {
                this.keyBlockEntry.expand();
            } else {
                this.keyBlock.createNewAfter();
                this.keyBlockEntry.expand();
                this.markToRebalance();
            }
            this.fillNewKeyEntry(blockIndex, offset, record);
        }
        finally {
            this.keyBlockEntry.sync(syncBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertKeyEntry(long blockIndex, long offset, Record record) {
        boolean syncBefore = this.keyBlockEntry.sync(false);
        try {
            if (this.keyBlock.hasFreeSpace()) {
                if (this.keyBlockEntry.valid()) {
                    this.keyBlockEntry.insert();
                } else {
                    this.keyBlockEntry.expand();
                }
            } else {
                if (this.keyBlockEntry.isFirst() && !this.keyBlock.isRoot()) {
                    long hash = this.keyBlockEntry.getHash();
                    this.keyBlock.previous();
                    if (this.keyBlock.hasFreeSpace()) {
                        this.keyBlockEntry.expand();
                        this.fillNewKeyEntry(blockIndex, offset, record);
                        return;
                    }
                    this.keyBlockEntry.moveToHash(hash);
                }
                int moveStartIndex = this.keyBlockEntry.getIndex();
                int beforeBlockIndex = this.keyBlock.getIndex();
                this.keyBlock.createNewAfter();
                this.markToRebalance();
                this.keyBlock.moveEntriesFrom(beforeBlockIndex, moveStartIndex);
                this.keyBlock.moveTo(beforeBlockIndex);
                this.keyBlockEntry.expand();
            }
            this.fillNewKeyEntry(blockIndex, offset, record);
        }
        finally {
            this.keyBlockEntry.sync(syncBefore);
        }
    }

    private int findAfter(byte[] key) {
        this.keyBlock.root();
        if (this.keyBlock.getEntriesNumber() == 0) {
            this.keyBlock.next();
        }
        if (this.keyBlock.invalid()) {
            return -1;
        }
        this.keyBlockEntry.last();
        int startIndex = this.keyBlock.getIndex();
        int stopIndex = this.keyBlock.getBlockSequence().length() - 1;
        int cmp = this.varSizeBlock.compare(key);
        if (cmp == 0) {
            return 0;
        }
        if (cmp < 0) {
            return this.searchInBlock(key);
        }
        if (startIndex == stopIndex) {
            return 1;
        }
        while (stopIndex - startIndex != 1) {
            int next = (startIndex + stopIndex) / 2;
            this.keyBlock.moveTo(next);
            this.keyBlockEntry.last();
            cmp = this.varSizeBlock.compare(key);
            if (cmp == 0) {
                return 0;
            }
            if (cmp < 0) {
                stopIndex = next;
                continue;
            }
            startIndex = next;
        }
        this.keyBlock.moveTo(stopIndex);
        return this.searchInBlock(key);
    }

    private int searchInBlock(byte[] key) {
        this.keyBlockEntry.first();
        int cmp = this.varSizeBlock.compare(key);
        if (cmp == 0) {
            return 0;
        }
        if (cmp < 0) {
            return -1;
        }
        int startIndex = 0;
        int stopIndex = this.keyBlockEntry.getEntriesNumber() - 1;
        if (stopIndex == startIndex) {
            return 1;
        }
        while (stopIndex - startIndex != 1) {
            int next = (startIndex + stopIndex) / 2;
            this.keyBlockEntry.moveTo(next);
            cmp = this.varSizeBlock.compare(key);
            if (cmp == 0) {
                return 0;
            }
            if (cmp < 0) {
                stopIndex = next;
                continue;
            }
            startIndex = next;
        }
        this.keyBlockEntry.moveTo(stopIndex);
        return this.varSizeBlock.compare(key);
    }

    public KeyList list(byte[] startWithKey, byte[] continuationKey, long maxNumber, long maxSize) {
        KeyList keyList = new KeyList();
        if (continuationKey != null) {
            int cmp = this.findAfter(continuationKey);
            if (cmp == 0) {
                this.keyBlockEntry.next();
                if (this.keyBlockEntry.invalid()) {
                    this.keyBlock.next();
                    if (this.keyBlock.invalid()) {
                        return keyList;
                    }
                    this.keyBlockEntry.first();
                }
            }
        } else if (startWithKey != null && startWithKey.length != 0) {
            this.findAfter(startWithKey);
        } else {
            this.keyBlock.root();
            if (this.keyBlockEntry.getEntriesNumber() == 0) {
                this.keyBlock.next();
            }
            if (this.keyBlock.invalid()) {
                return keyList;
            }
            this.keyBlockEntry.first();
        }
        if (this.keyBlockEntry.invalid()) {
            return keyList;
        }
        long timeSec = System.currentTimeMillis() / 1000L;
        do {
            if (!this.keyBlockEntry.isExpired(timeSec)) {
                byte[] key = this.varSizeBlock.extract();
                if (startWithKey != null) {
                    if (key.length < startWithKey.length) {
                        return keyList;
                    }
                    for (int i = startWithKey.length - 1; i >= 0; --i) {
                        if (startWithKey[i] == key[i]) continue;
                        return keyList;
                    }
                }
                keyList.addKey(key);
            }
            this.keyBlockEntry.next();
            if (!this.keyBlockEntry.invalid()) continue;
            this.keyBlock.next();
            if (this.keyBlock.invalid()) {
                return keyList;
            }
            this.keyBlockEntry.first();
            if (!this.keyBlockEntry.invalid()) continue;
            return keyList;
        } while (keyList.getSize() < maxSize && (long)keyList.getKeys().size() < maxNumber);
        keyList.setMore(true);
        return keyList;
    }

    public Record getRecord(byte[] key) {
        int cmp = this.findAfter(key);
        if (cmp == 0) {
            if (this.keyBlockEntry.isExpired()) {
                return null;
            }
            return this.keyBlockEntry.getRecord();
        }
        return null;
    }

    @Override
    public void close() {
        this.keyBlock.getBlockSequence().close();
        this.keyBlock.getBlockSequence().getBlockProvider().getBlockContainer().close();
    }

    @Override
    public Status getStatus() {
        return this.keyBlock.getBlockSequence().getStatus();
    }

    @Override
    public void commit() {
        this.keyBlock.getBlockSequence().getBlockProvider().getBlockContainer().commit();
    }
}

