/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.keys;

import org.rostore.Utils;
import org.rostore.entity.Record;
import org.rostore.v2.fixsize.FixSizeEntry;
import org.rostore.v2.fixsize.FixSizeEntryBlock;
import org.rostore.v2.keys.RecordLengths;
import org.rostore.v2.keys.VarSizeBlock;
import org.rostore.v2.keys.VarSizeEntry;
import org.rostore.v2.keys.VarSizeMultiBlock;
import org.rostore.v2.media.block.Block;

public class KeyBlockEntry
extends FixSizeEntry {
    private final VarSizeBlock varSizeBlock;
    private final VarSizeEntry varSizeEntry;
    private final VarSizeMultiBlock varSizeMultiBlock;
    private boolean initVarCall = false;
    private boolean sync = true;
    private final RecordLengths recordLengths;

    public RecordLengths getRecordLengths() {
        return this.recordLengths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("KeyBlockEntry:");
        int oldPosition = this.getFixSizeEntryBlock().getBlock().position();
        try {
            if (this.invalid()) {
                sb.append(" invalid");
            } else {
                sb.append(" id ");
                sb.append(this.getId());
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.getFixSizeEntryBlock().getBlock().position(oldPosition);
        }
    }

    public boolean sync(boolean value) {
        boolean before = this.sync;
        this.sync = value;
        if (this.valid() && this.sync) {
            this.initVarSize();
        }
        return before;
    }

    protected KeyBlockEntry(FixSizeEntryBlock<KeyBlockEntry> keyBlock, VarSizeBlock varSizeBlock, RecordLengths recordLengths) {
        super(keyBlock);
        this.varSizeBlock = varSizeBlock;
        this.varSizeEntry = varSizeBlock.getEntry();
        this.varSizeMultiBlock = varSizeBlock.getMultiBlock();
        this.recordLengths = recordLengths;
    }

    @Override
    public void moveTo(int index) {
        super.moveTo(index);
        if (this.valid() && !this.initVarCall && this.sync) {
            this.initVarSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVarSize() {
        this.initVarCall = true;
        try {
            this.throwExceptionIfInvalid("get block index");
            Block block = this.getFixSizeEntryBlock().getBlock();
            block.position(this.getEntryLocation());
            long blockIndex = block.readBlockIndex();
            int blockOffset = (int)block.getLong(this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
            this.varSizeBlock.moveTo(blockIndex);
            if (this.varSizeBlock.isMultiEntry()) {
                this.varSizeEntry.setOffset(blockOffset);
                long nextOffset = -1L;
                long copy = this.getHash();
                this.next();
                if (this.valid()) {
                    if (blockIndex == this.getBlockIndex()) {
                        nextOffset = this.getBlockOffset();
                    }
                } else {
                    this.getFixSizeEntryBlock().next();
                    if (this.getFixSizeEntryBlock().valid() && blockIndex == this.getBlockIndex()) {
                        nextOffset = this.getBlockOffset();
                    }
                }
                this.moveToHash(copy);
                int size = -1;
                if (nextOffset != -1L) {
                    size = (int)(nextOffset - (long)blockOffset);
                }
                this.varSizeEntry.setEntrySize(size);
            } else {
                this.varSizeMultiBlock.root();
            }
        }
        finally {
            this.initVarCall = false;
        }
    }

    public long getBlockIndex() {
        this.throwExceptionIfInvalid("get block index");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation());
        return block.readBlockIndex();
    }

    public long getId() {
        this.throwExceptionIfInvalid("get id");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        return block.getLong(this.recordLengths.getIdLength());
    }

    public void setRecord(Record record) {
        this.throwExceptionIfInvalid("set record");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        block.putLong(record.getId(), this.recordLengths.getIdLength());
        block.putLong(record.getEol(), this.recordLengths.getEolLength());
        block.putLong(record.getVersion(), this.recordLengths.getVersionLength());
    }

    public Record getRecord() {
        this.throwExceptionIfInvalid("get id and ttl and version");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        Record record = new Record();
        record.id(block.getLong(this.recordLengths.getIdLength()));
        if (this.recordLengths.getEolLength() != 0) {
            record.eol(block.getLong(this.recordLengths.getEolLength()));
        }
        if (this.recordLengths.getVersionLength() != 0) {
            record.version(block.getLong(this.recordLengths.getVersionLength()));
        }
        return record;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis() / 1000L);
    }

    public boolean isExpired(long currentTimeSecs) {
        this.throwExceptionIfInvalid("is expired");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset() + this.recordLengths.getIdLength());
        return Utils.isExpiredEOL((long)block.getLong(this.recordLengths.getEolLength()), (long)currentTimeSecs);
    }

    public void setBlockIndex(long value) {
        this.throwExceptionIfInvalid("set block index");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation());
        block.writeBlockIndex(value);
    }

    public long getBlockOffset() {
        this.throwExceptionIfInvalid("get block offset");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        return block.getLong(this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }

    public void setBlockOffset(long value) {
        this.throwExceptionIfInvalid("get block offset");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        block.putLong(value, this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }

    public void incBlockOffset(long add) {
        this.throwExceptionIfInvalid("get block offset");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        long value = block.getLong(this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        block.back(this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
        block.putLong(value += add, this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset());
    }

    @Override
    public int getEntrySize() {
        return this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockOffset() + this.recordLengths.getTotalLength();
    }

    public VarSizeBlock getVarSizeBlock() {
        return this.varSizeBlock;
    }
}

