/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.fixsize;

import java.util.function.Function;
import org.rostore.Utils;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.EntrySizeListener;
import org.rostore.v2.fixsize.FixSizeEntry;
import org.rostore.v2.fixsize.ValidatingEntry;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.seq.BlockSequence;
import org.rostore.v2.seq.SequenceBlock;

public class FixSizeEntryBlock<T extends FixSizeEntry>
extends SequenceBlock {
    private final T fixSizeEntry;
    private int firstHeaderSize;
    private int bytesPerEntryNumber;
    private final EntrySizeListener newEntryNumberListener;

    public BlockProvider getBlockProvider() {
        return super.getBlockSequence().getBlockProvider();
    }

    public T getEntry() {
        return this.fixSizeEntry;
    }

    @Override
    public int getHeaderSize() {
        this.throwExceptionIfInvalid("header size");
        if (this.isRoot()) {
            return this.getFirstHeaderSize();
        }
        return this.getRegularHeaderSize();
    }

    public int getRegularHeaderSize() {
        return super.getHeaderSize() + this.bytesPerEntryNumber;
    }

    public int getFirstHeaderSize() {
        return this.getRegularHeaderSize() + this.firstHeaderSize;
    }

    public int getEntryCapacity() {
        this.throwExceptionIfInvalid("get capacity");
        return (this.getBlockSequence().getBlockProvider().getBlockContainer().getMedia().getMediaProperties().getBlockSize() - this.getHeaderSize()) / ((FixSizeEntry)this.fixSizeEntry).getEntrySize();
    }

    protected void throwExceptionIfInvalid(String message) {
        if (this.invalid()) {
            throw new RoStoreException("The <" + String.valueOf(this) + "> is invalid: " + message);
        }
    }

    public int addEntriesNumber(int number) {
        this.throwExceptionIfInvalid("dec number of entries");
        Block block = this.getBlock();
        block.position(this.getBlockSequence().getBlockProvider().getBlockContainer().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        long oldNumber = block.getLong(this.bytesPerEntryNumber);
        long result = oldNumber + (long)number;
        block.back(this.bytesPerEntryNumber);
        block.putLong(result, this.bytesPerEntryNumber);
        ((ValidatingEntry)this.fixSizeEntry).validate();
        if (this.newEntryNumberListener != null) {
            this.newEntryNumberListener.apply(result, number);
        }
        return (int)result;
    }

    public int getEntriesNumber() {
        this.throwExceptionIfInvalid("get number of entries");
        Block block = this.getBlock();
        block.position(this.getBlockSequence().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        return (int)block.getLong(this.bytesPerEntryNumber);
    }

    public boolean hasFreeSpace() {
        this.throwExceptionIfInvalid("check free space");
        return this.getEntryCapacity() - this.getEntriesNumber() != 0;
    }

    @Override
    public void createNewAfter() {
        this.throwExceptionIfInvalid("create new after");
        super.createNewAfter();
        ((ValidatingEntry)this.fixSizeEntry).invalidate();
    }

    @Override
    protected boolean isUnused() {
        return this.getEntriesNumber() == 0;
    }

    public void moveEntriesFrom(int sourceIndex, int sourceEntryStartIndex) {
        int thisIndex = this.getIndex();
        this.moveTo(sourceIndex);
        Block sourceBlock = this.getBlock();
        ((ValidatingEntry)this.fixSizeEntry).moveTo(sourceEntryStartIndex);
        int sourcePosition = ((FixSizeEntry)this.fixSizeEntry).getEntryLocation();
        int entriesToMove = this.getEntriesNumber() - sourceEntryStartIndex;
        int bytesToMove = ((FixSizeEntry)this.fixSizeEntry).getEntrySize() * entriesToMove;
        this.moveTo(thisIndex);
        Block targetBlock = this.getBlock();
        ((ValidatingEntry)this.fixSizeEntry).last();
        int targetPosition = ((FixSizeEntry)this.fixSizeEntry).getEntriesNumber() == 0 ? this.getHeaderSize() : ((FixSizeEntry)this.fixSizeEntry).getEntryLocation() + ((FixSizeEntry)this.fixSizeEntry).getEntrySize();
        targetBlock.position(targetPosition);
        sourceBlock.position(sourcePosition);
        targetBlock.put(sourceBlock, bytesToMove);
        this.addEntriesNumber(entriesToMove);
        this.moveTo(sourceIndex);
        this.addEntriesNumber(-entriesToMove);
    }

    public FixSizeEntryBlock(BlockSequence<FixSizeEntryBlock> sequence, int firstHeaderSize, Function<FixSizeEntryBlock<T>, T> entryFactory, EntrySizeListener newEntryNumberListener) {
        super(sequence);
        this.firstHeaderSize = firstHeaderSize;
        this.fixSizeEntry = (FixSizeEntry)entryFactory.apply(this);
        this.newEntryNumberListener = newEntryNumberListener;
        int maxEntryNumber = (this.getBlockSequence().getBlockProvider().getMedia().getMediaProperties().getBlockSize() - this.getRegularHeaderSize()) / ((FixSizeEntry)this.fixSizeEntry).getEntrySize();
        this.bytesPerEntryNumber = Utils.computeBytesForMaxValue((long)maxEntryNumber);
        this.root();
    }

    @Override
    public boolean valid() {
        return super.valid();
    }

    public String toString() {
        String validPart;
        if (this.valid()) {
            Block block = super.getBlock();
            validPart = "#" + super.getIndex() + " " + String.valueOf(block) != null ? "block=" + block.toString() : "no-block";
        } else {
            validPart = "invalid";
        }
        return "FixSizeEntryBlock: " + validPart;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.fixSizeEntry != null) {
            ((ValidatingEntry)this.fixSizeEntry).invalidate();
        }
    }

    @Override
    public void moveTo(int index) {
        super.moveTo(index);
        if (this.fixSizeEntry != null) {
            if (super.invalid()) {
                ((ValidatingEntry)this.fixSizeEntry).invalidate();
            } else {
                ((ValidatingEntry)this.fixSizeEntry).moveTo(0);
            }
        }
    }
}

