/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.fixsize;

import org.rostore.entity.RoStoreException;
import org.rostore.v2.fixsize.FixSizeEntryBlock;
import org.rostore.v2.fixsize.ValidatingEntry;
import org.rostore.v2.media.block.Block;

public abstract class FixSizeEntry
extends ValidatingEntry {
    private FixSizeEntryBlock fixSizeEntryBlock;

    @Override
    public int getEntriesNumber() {
        return this.fixSizeEntryBlock.getEntriesNumber();
    }

    public long getHash() {
        long hash = this.fixSizeEntryBlock.getIndex();
        hash <<= 32;
        long indexLong = this.getIndex();
        return hash |= (indexLong &= 0xFFFFFFFFFFFFFFFFL);
    }

    public void moveToHash(long hash) {
        if (hash == -1L) {
            this.fixSizeEntryBlock.invalidate();
        } else {
            int catalogBlockIndex = (int)(hash >> 32 & 0xFFFFFFFFFFFFFFFFL);
            int entryIndex = (int)(hash & 0xFFFFFFFFFFFFFFFFL);
            this.fixSizeEntryBlock.moveTo(catalogBlockIndex);
            if (this.fixSizeEntryBlock.valid()) {
                this.moveTo(entryIndex);
            } else {
                this.invalidate();
            }
        }
    }

    @Override
    public String toString() {
        int oldPosition = this.getFixSizeEntryBlock().getBlock().position();
        try {
            String string = super.toString() + ", location=" + this.getEntryLocation() + ", " + this.fixSizeEntryBlock.toString();
            return string;
        }
        finally {
            this.getFixSizeEntryBlock().getBlock().position(oldPosition);
        }
    }

    public FixSizeEntryBlock getFixSizeEntryBlock() {
        return this.fixSizeEntryBlock;
    }

    protected int getEntryLocation() {
        int entriesNumber = this.fixSizeEntryBlock.getEntriesNumber();
        int index = this.getIndex();
        if (index < 0 || index >= this.fixSizeEntryBlock.getEntriesNumber()) {
            throw new RoStoreException("The entry index " + index + " does not exist. max=" + entriesNumber);
        }
        return this.fixSizeEntryBlock.getHeaderSize() + index * this.getEntrySize();
    }

    public void expand() {
        if (this.fixSizeEntryBlock.getEntriesNumber() >= this.fixSizeEntryBlock.getEntryCapacity()) {
            throw new RoStoreException("Can't add entry. Number of entries: " + this.fixSizeEntryBlock.getEntriesNumber() + ", capacity: " + this.fixSizeEntryBlock.getEntryCapacity());
        }
        int newSize = this.fixSizeEntryBlock.addEntriesNumber(1);
        this.moveTo(newSize - 1);
    }

    public void remove() {
        this.throwExceptionIfInvalid("remove the entry");
        Block block = this.fixSizeEntryBlock.getBlock();
        int tailSize = (this.fixSizeEntryBlock.getEntriesNumber() - this.getIndex() - 1) * this.getEntrySize();
        block.position(this.getEntryLocation());
        block.collapseWindow(this.getEntrySize(), tailSize);
        this.fixSizeEntryBlock.addEntriesNumber(-1);
    }

    public void insert() {
        Block block = this.fixSizeEntryBlock.getBlock();
        int entrySize = this.getEntrySize();
        int tailSize = (this.fixSizeEntryBlock.getEntriesNumber() - this.getIndex()) * entrySize;
        block.position(this.getEntryLocation());
        block.insertWindows(entrySize, tailSize);
        this.fixSizeEntryBlock.addEntriesNumber(1);
    }

    public FixSizeEntry(FixSizeEntryBlock freeBlock) {
        this.fixSizeEntryBlock = freeBlock;
        if (this.fixSizeEntryBlock.valid()) {
            if (this.fixSizeEntryBlock.getEntriesNumber() == 0) {
                this.invalidate();
            } else {
                this.moveTo(0);
            }
        } else {
            this.invalidate();
        }
    }

    public abstract int getEntrySize();
}

