/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rostore.Utils;
import org.rostore.mapper.BinaryMapper;
import org.rostore.mapper.MapperProperties;
import org.rostore.v2.data.DataTransferException;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockProviderImpl;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.container.Status;

public class DataWriter
extends OutputStream
implements Committable {
    private static final Logger logger = Logger.getLogger(DataWriter.class.getName());
    final BlockProvider internalBlockProvider;
    private long root;
    private Block current = null;
    private long length;

    public static long safeWriter(BlockAllocator blockAllocator, Consumer<DataWriter> dataWriterConsumer) {
        return DataWriter.safeWriter(blockAllocator, -1L, dataWriterConsumer);
    }

    public static <T> long writeObject(BlockAllocator blockAllocator, T object) {
        return DataWriter.safeWriter(blockAllocator, -1L, dw -> dw.writeObject(object));
    }

    @Override
    public void write(byte[] b) {
        try {
            super.write(b);
        }
        catch (IOException e) {
            throw new DataTransferException(e);
        }
    }

    public static long safeWriter(BlockAllocator blockAllocator, long startIndex, Consumer<DataWriter> dataWriterConsumer) {
        DataWriter dataWriter = DataWriter.open(blockAllocator, startIndex);
        try {
            dataWriterConsumer.accept(dataWriter);
            long id = dataWriter.getStartIndex();
            dataWriter.close();
            return id;
        }
        catch (Exception e) {
            try {
                dataWriter.unwind();
            }
            catch (Exception unwindE) {
                logger.log(Level.SEVERE, "Exception happened in data-writing operation", e);
                throw new DataTransferException("Exception after broken data-writing unwinding", unwindE);
            }
            throw new DataTransferException(e);
        }
    }

    public static DataWriter open(BlockAllocator blockAllocator, long startIndex) {
        return new DataWriter(BlockProviderImpl.internal(blockAllocator), startIndex);
    }

    public static <T extends InputStream> long fromInputStream(BlockAllocator blockAllocator, T inputStream) {
        return DataWriter.safeWriter(blockAllocator, dw -> {
            try {
                inputStream.transferTo((OutputStream)dw);
            }
            catch (IOException e) {
                throw new DataTransferException(e);
            }
        });
    }

    private DataWriter(BlockProvider blockProvider, long startIndex) {
        this.internalBlockProvider = blockProvider;
        this.root = startIndex;
        if (startIndex != -1L) {
            this.current = this.internalBlockProvider.getBlockContainer().getBlock(this.root, BlockType.DATA);
            this.current.position(0);
        }
        this.length = 0L;
    }

    public long getStartIndex() {
        return this.root;
    }

    private void stop() {
        if (this.length == 0L) {
            return;
        }
        int lengthLength = Utils.computeBytesForMaxValue((long)this.length);
        int capacity = this.getRegularCapacity();
        if (this.root == this.current.getAbsoluteIndex()) {
            if (capacity >= lengthLength + 1) {
                this.current.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() - lengthLength - 1);
                this.current.putLong(this.length, lengthLength);
                this.current.putByte((byte)lengthLength);
                this.current.writeBlockIndex(this.root);
            } else {
                this.attachNextBlock();
                this.finalizeLast(lengthLength);
            }
        } else {
            if (capacity < lengthLength) {
                this.attachNextBlock();
            }
            this.finalizeLast(lengthLength);
        }
    }

    private void finalizeLast(int lengthLength) {
        this.current.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - lengthLength - 1);
        this.current.putLong(this.length, lengthLength);
        this.current.putByte((byte)lengthLength);
        Block rootBlock = this.internalBlockProvider.getBlockContainer().getBlock(this.root, BlockType.DATA);
        rootBlock.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() * 2);
        rootBlock.writeBlockIndex(this.current.getAbsoluteIndex());
    }

    public <T> void writeObject(T object) {
        BinaryMapper.serialize((MapperProperties)this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties(), object, (OutputStream)this);
    }

    @Override
    public void write(int data) {
        if (this.length == 0L && this.root == -1L) {
            this.current = this.internalBlockProvider.allocateBlock(BlockType.DATA);
            this.root = this.current.getAbsoluteIndex();
            this.current.position(0);
        }
        int capacity = this.getRegularCapacity();
        if (this.root == this.current.getAbsoluteIndex()) {
            capacity -= this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
        }
        if (capacity <= 0) {
            this.attachNextBlock();
        }
        this.current.putByte((byte)data);
        ++this.length;
    }

    private int getRegularCapacity() {
        int capacity = this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize();
        if (this.current != null) {
            capacity -= this.current.position();
        }
        return capacity -= this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
    }

    private void attachNextBlock() {
        Block next = this.internalBlockProvider.allocateBlock(BlockType.DATA);
        next.position(0);
        this.current.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        this.current.writeBlockIndex(next.getAbsoluteIndex());
        if (this.current.getAbsoluteIndex() != this.root) {
            this.current.close();
        }
        this.current = next;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.stop();
        this.internalBlockProvider.getBlockContainer().close();
    }

    @Override
    public Status getStatus() {
        return this.internalBlockProvider.getBlockContainer().getStatus();
    }

    public void unwind() {
        if (this.current == null) {
            return;
        }
        if (this.current.getAbsoluteIndex() == this.root) {
            this.internalBlockProvider.freeBlock(this.root);
            this.internalBlockProvider.getBlockContainer().close();
        } else {
            long nextNext;
            long next = this.root;
            do {
                Block iterator = this.internalBlockProvider.getBlockContainer().getBlock(next, BlockType.DATA);
                iterator.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
                nextNext = iterator.readBlockIndex();
                this.internalBlockProvider.freeBlock(next);
            } while ((next = nextNext) != this.current.getAbsoluteIndex());
            this.internalBlockProvider.freeBlock(next);
            this.internalBlockProvider.getBlockContainer().close();
        }
    }

    @Override
    public void commit() {
        this.internalBlockProvider.getBlockContainer().commit();
    }
}

