/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.rostore.mapper.BinaryMapper;
import org.rostore.mapper.MapperProperties;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.data.DataTransferException;
import org.rostore.v2.media.Committable;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockProviderImpl;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.allocator.BlockAllocator;
import org.rostore.v2.media.block.container.Status;

public class DataReader
extends InputStream
implements Committable {
    final BlockProvider internalBlockProvider;
    private long root;
    private Block current;
    private long length = 0L;
    private long position = 0L;
    private long lastIndex;

    public static DataReader open(Media media, long startIndex) {
        return new DataReader(BlockProviderImpl.internal(media), startIndex);
    }

    public static DataReader open(BlockAllocator allocator, long startIndex) {
        return new DataReader(BlockProviderImpl.internal(allocator), startIndex);
    }

    public static void safeReader(Media media, long startIndex, Consumer<DataReader> dataReaderConsumer) {
        try (DataReader dr = DataReader.open(media, startIndex);){
            dataReaderConsumer.accept(dr);
        }
        catch (Exception e) {
            throw new DataTransferException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(Media media, long startIndex, Class<T> clazz) {
        try (DataReader dr = DataReader.open(media, startIndex);){
            T t = dr.readObject(clazz);
            return t;
        }
        catch (Exception e) {
            throw new DataTransferException(e);
        }
    }

    public static <T extends OutputStream> void toOutputStream(Media media, long startIndex, T outputStream) {
        try (DataReader dr = DataReader.open(media, startIndex);){
            dr.transferTo(outputStream);
        }
        catch (IOException e) {
            throw new DataTransferException(e);
        }
    }

    private DataReader(BlockProvider internalBlockProvider, long startIndex) {
        this.internalBlockProvider = internalBlockProvider;
        this.root = startIndex;
        this.current = internalBlockProvider.getBlockContainer().getBlock(this.root, BlockType.DATA);
        this.current.position(internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        long nextIndex = this.current.readBlockIndex();
        if (nextIndex == this.root) {
            this.lastIndex = this.root;
            this.current.position(internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() - 1);
            byte lengthLength = this.current.getByte();
            this.current.back(lengthLength + 1);
            this.length = this.current.getLong(lengthLength);
        } else {
            this.current.position(internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() * 2);
            this.lastIndex = this.current.readBlockIndex();
            Block lastBlock = internalBlockProvider.getBlockContainer().getBlock(this.lastIndex, BlockType.DATA);
            lastBlock.position(internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - 1);
            byte lengthLength = lastBlock.getByte();
            lastBlock.back(lengthLength + 1);
            this.length = lastBlock.getLong(lengthLength);
        }
        this.current.position(0);
    }

    public <T> T readObject(Class<T> clazz) {
        return (T)BinaryMapper.deserialize((MapperProperties)this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties(), clazz, (InputStream)this);
    }

    public long length() {
        return this.length;
    }

    public long position() {
        return this.position;
    }

    @Override
    public int read() {
        if (this.position >= this.length) {
            return -1;
        }
        if (this.root == this.lastIndex) {
            ++this.position;
            return this.current.getByte() & 0xFF;
        }
        if (this.current.getAbsoluteIndex() == this.lastIndex) {
            ++this.position;
            return this.current.getByte() & 0xFF;
        }
        int capacity = this.getRegularCapacity();
        if (this.root == this.current.getAbsoluteIndex()) {
            capacity -= this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
        }
        if (capacity <= 0) {
            this.moveToNextBlock();
        }
        ++this.position;
        return this.current.getByte() & 0xFF;
    }

    public void free() {
        this.iterateIndices(catalogBlockIndices -> this.internalBlockProvider.getBlockAllocator().free((CatalogBlockIndices)catalogBlockIndices));
    }

    public void iterateIndices(Consumer<CatalogBlockIndices> consumer) {
        this.current = this.internalBlockProvider.getBlockContainer().getBlock(this.root, BlockType.DATA);
        CatalogBlockIndices indices = new CatalogBlockIndices();
        while (true) {
            indices.add(this.current.getAbsoluteIndex(), this.current.getAbsoluteIndex());
            if (this.current.getAbsoluteIndex() == this.lastIndex) {
                this.current.close();
                consumer.accept(indices);
                return;
            }
            this.current.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
            long nextBlock = this.current.readBlockIndex();
            this.current.close();
            this.current = this.internalBlockProvider.getBlockContainer().getBlock(nextBlock, BlockType.DATA);
            if (indices.getGroupNumber() < 600) continue;
            consumer.accept(indices);
            indices.clear();
        }
    }

    public boolean hasMore() {
        return this.position < this.length;
    }

    private int getRegularCapacity() {
        int capacity = this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize();
        capacity -= this.current.position();
        return capacity -= this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
    }

    private void moveToNextBlock() {
        this.current.position(this.internalBlockProvider.getMedia().getMediaProperties().getBlockSize() - this.internalBlockProvider.getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        long nextIndex = this.current.readBlockIndex();
        Block next = this.internalBlockProvider.getBlockContainer().getBlock(nextIndex, BlockType.DATA);
        next.position(0);
        this.current.close();
        this.current = next;
    }

    @Override
    public void close() {
        try {
            super.close();
            this.internalBlockProvider.getBlockContainer().close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Status getStatus() {
        return this.internalBlockProvider.getBlockContainer().getStatus();
    }

    @Override
    public void commit() {
        this.internalBlockProvider.getBlockContainer().commit();
    }
}

