/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import java.util.ArrayList;
import java.util.List;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockIndicesIterator;

public class CatalogBlockIndices {
    private static final int START = 0;
    private static final int STOP = 1;
    private int length = 0;
    private List<long[]> blockEntries = new ArrayList<long[]>();

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean added = false;
        for (long[] entry : this.blockEntries) {
            if (added) {
                sb.append(",");
            }
            sb.append(entry[0]);
            sb.append("..");
            sb.append(entry[1]);
            added = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public void clear() {
        this.blockEntries.clear();
        this.length = 0;
    }

    public void add(long startIndex, long stopIndex) {
        if (startIndex > stopIndex) {
            throw new RoStoreException("Start index " + startIndex + " > " + stopIndex + " stop index.");
        }
        this.insert(startIndex, stopIndex);
        this.length = (int)((long)this.length + (stopIndex - startIndex + 1L));
    }

    public CatalogBlockIndices remove(long startIndex, long stopIndex) {
        if (startIndex > stopIndex) {
            throw new RoStoreException("Start index " + startIndex + " > " + stopIndex + " stop index.");
        }
        return this.removeStartStop(startIndex, stopIndex);
    }

    public CatalogBlockIndices remove(CatalogBlockIndices catalogBlockIndices) {
        CatalogBlockIndices notRemoved = new CatalogBlockIndices();
        for (int i = 0; i < catalogBlockIndices.blockEntries.size(); ++i) {
            notRemoved.add(this.removeStartStop(catalogBlockIndices.blockEntries.get(i)[0], catalogBlockIndices.blockEntries.get(i)[1]));
        }
        return notRemoved;
    }

    private long[] wrap(long start, long stop) {
        return new long[]{start, stop};
    }

    private void insert(long start, long stop) {
        if (this.blockEntries.isEmpty()) {
            this.blockEntries.add(this.wrap(start, stop));
            return;
        }
        long first = this.blockEntries.get(0)[0];
        if (stop < first) {
            if (first == stop + 1L) {
                this.blockEntries.get((int)0)[0] = start;
            } else {
                this.blockEntries.add(0, this.wrap(start, stop));
            }
            return;
        }
        long last = this.blockEntries.get(this.blockEntries.size() - 1)[1];
        if (last < start) {
            if (last == start - 1L) {
                this.blockEntries.get((int)(this.blockEntries.size() - 1))[1] = stop;
            } else {
                this.blockEntries.add(this.wrap(start, stop));
            }
            return;
        }
        for (int i = 1; i < this.blockEntries.size(); ++i) {
            long[] current = this.blockEntries.get(i);
            if (current[0] <= stop) continue;
            long[] prev = this.blockEntries.get(i - 1);
            if (current[0] == stop + 1L) {
                if (prev[1] == start - 1L) {
                    prev[1] = current[1];
                    this.blockEntries.remove(i);
                } else {
                    current[0] = start;
                }
                return;
            }
            if (prev[1] == start - 1L) {
                prev[1] = stop;
                return;
            }
            this.blockEntries.add(i, this.wrap(start, stop));
            return;
        }
    }

    private CatalogBlockIndices removeStartStop(long start, long stop) {
        long[] current;
        int i;
        CatalogBlockIndices ret = new CatalogBlockIndices();
        if (this.blockEntries.isEmpty()) {
            ret.add(start, stop);
            return ret;
        }
        int startIndex = -1;
        int stopIndex = -1;
        for (i = 0; i < this.blockEntries.size(); ++i) {
            current = this.blockEntries.get(i);
            if (current[1] < start) continue;
            if (current[0] > stop) break;
            if (startIndex == -1) {
                startIndex = i;
            }
            stopIndex = i;
        }
        if (startIndex == -1) {
            ret.add(start, stop);
            return ret;
        }
        current = this.blockEntries.get(startIndex);
        if (current[0] > start) {
            ret.add(start, current[0] - 1L);
            start = current[0];
        }
        if ((current = this.blockEntries.get(stopIndex))[1] < stop) {
            ret.add(current[1] + 1L, stop);
            stop = current[1];
        }
        if (startIndex == stopIndex) {
            current = this.blockEntries.get(stopIndex);
            if (start > current[0]) {
                if (stop == current[1]) {
                    this.length = (int)((long)this.length - (current[1] - start + 1L));
                    current[1] = start - 1L;
                } else {
                    this.length = (int)((long)this.length - (stop - start + 1L));
                    long prevStop = current[1];
                    current[1] = start - 1L;
                    long[] newOne = new long[]{stop + 1L, prevStop};
                    this.blockEntries.add(startIndex + 1, newOne);
                }
            } else if (stop == current[1]) {
                this.length = (int)((long)this.length - (stop - start + 1L));
                this.blockEntries.remove(startIndex);
            } else {
                this.length = (int)((long)this.length - (stop - current[0] + 1L));
                current[0] = stop + 1L;
            }
            return ret;
        }
        for (i = startIndex; i < stopIndex; ++i) {
            long[] left = this.blockEntries.get(i);
            long[] right = this.blockEntries.get(i + 1);
            ret.add(left[1] + 1L, right[0] - 1L);
        }
        current = this.blockEntries.get(stopIndex);
        if (current[1] > stop) {
            this.length = (int)((long)this.length - (stop - current[0] + 1L));
            current[0] = stop + 1L;
        } else {
            this.length = (int)((long)this.length - (this.blockEntries.get(stopIndex)[1] - this.blockEntries.get(stopIndex)[0] + 1L));
            this.blockEntries.remove(stopIndex);
        }
        --stopIndex;
        current = this.blockEntries.get(startIndex);
        if (current[0] < start) {
            this.length = (int)((long)this.length - (current[1] - start + 1L));
            current[1] = start - 1L;
        } else {
            this.length = (int)((long)this.length - (this.blockEntries.get(startIndex)[1] - this.blockEntries.get(startIndex)[0] + 1L));
            this.blockEntries.remove(startIndex);
        }
        for (i = ++startIndex; i <= stopIndex; ++i) {
            this.length = (int)((long)this.length - (this.blockEntries.get(i)[1] - this.blockEntries.get(i)[0] + 1L));
            this.blockEntries.remove(startIndex);
        }
        return ret;
    }

    public void add(CatalogBlockIndices catalogBlockIndices) {
        for (int i = 0; i < catalogBlockIndices.getGroupNumber(); ++i) {
            this.add(catalogBlockIndices.getGroup(i)[0], catalogBlockIndices.getGroup(i)[1]);
        }
    }

    public CatalogBlockIndices extract(int length) {
        if (length > this.length) {
            throw new RoStoreException("Can't extract " + length + " from the the block of " + this.length);
        }
        int left = length;
        CatalogBlockIndices ret = new CatalogBlockIndices();
        while (left != 0) {
            long[] last = this.blockEntries.get(this.blockEntries.size() - 1);
            long lastLength = last[1] - last[0] + 1L;
            if (lastLength <= (long)left) {
                ret.add(last[0], last[1]);
                this.blockEntries.remove(this.blockEntries.size() - 1);
                left = (int)((long)left - lastLength);
                this.length = (int)((long)this.length - lastLength);
                continue;
            }
            ret.add(last[1] - (long)left + 1L, last[1]);
            last[1] = last[1] - (long)left;
            this.length -= left;
            left = 0;
        }
        return ret;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.blockEntries.isEmpty();
    }

    public CatalogBlockIndicesIterator iterator() {
        return new CatalogBlockIndicesIterator(this);
    }

    public long getFirst() {
        if (this.blockEntries.isEmpty()) {
            throw new IndexOutOfBoundsException("The index is empty.");
        }
        return this.blockEntries.get(0)[0];
    }

    public long[] getGroup(int groupIndex) {
        return this.blockEntries.get(groupIndex);
    }

    public int getGroupNumber() {
        return this.blockEntries.size();
    }

    public boolean contains(long blockIndex) {
        for (int i = 0; i < this.blockEntries.size(); ++i) {
            long[] entry = this.blockEntries.get(i);
            if (entry[0] > blockIndex || entry[1] < blockIndex) continue;
            return true;
        }
        return false;
    }
}

