/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockEntry;
import org.rostore.v2.catalog.CatalogBlockEntryBase;

public class CatalogBlockEntryInstance {
    final CatalogBlockEntryBase catalogBlockEntry;
    private final long entryHash;
    private final long start;
    private final long stop;

    private void throwExceptionIfInvalid(String message) {
        if (this.invalid()) {
            throw new RoStoreException("The <" + String.valueOf(this) + "> is invalid: " + message);
        }
    }

    public long getStart() {
        this.throwExceptionIfInvalid("getStart");
        return this.start;
    }

    public long getStop() {
        this.throwExceptionIfInvalid("getStop");
        return this.stop;
    }

    public boolean valid() {
        return this.entryHash != -1L;
    }

    public boolean invalid() {
        return this.entryHash == -1L;
    }

    public CatalogBlockEntryInstance(CatalogBlockEntry catalogBlockEntry) {
        this.entryHash = catalogBlockEntry.getHash();
        this.start = catalogBlockEntry.getEntryStart();
        this.stop = catalogBlockEntry.getEntryStop();
        this.catalogBlockEntry = catalogBlockEntry;
    }

    public CatalogBlockEntryInstance(CatalogBlockEntryBase catalogBlockEntry, long hash) {
        this.entryHash = hash;
        this.catalogBlockEntry = catalogBlockEntry;
        if (hash != -1L) {
            catalogBlockEntry.moveToHash(hash);
            this.start = catalogBlockEntry.getEntryStart();
            this.stop = catalogBlockEntry.getEntryStop();
        } else {
            this.start = -1L;
            this.stop = -1L;
        }
    }

    public void restore() {
        this.catalogBlockEntry.moveToHash(this.entryHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CatalogBlockEntryInstance: ");
        if (this.invalid()) {
            sb.append("invalid");
        } else {
            sb.append("start=");
            sb.append(this.start);
            sb.append(", stop=");
            sb.append(this.stop);
        }
        return sb.toString();
    }
}

