/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.catalog;

import org.rostore.v2.fixsize.FixSizeEntry;
import org.rostore.v2.fixsize.FixSizeEntryBlock;
import org.rostore.v2.media.block.Block;

public class CatalogBlockEntryBase
extends FixSizeEntry {
    public void addNewEntryFor(long startIndex, long stopIndex) {
        this.expand();
        this.setEntryStartStop(startIndex, stopIndex);
    }

    public long getBlocksNumber() {
        this.throwExceptionIfInvalid("get number of blocks");
        return this.getEntryStop() - this.getEntryStart() + 1L;
    }

    public void setEntryStart(long newStart) {
        this.throwExceptionIfInvalid("set entry start");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation());
        block.writeBlockIndex(newStart);
    }

    public void setEntryStartStop(long newStart, long newStop) {
        this.throwExceptionIfInvalid("set entry start/stop");
        int location = this.getEntryLocation();
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(location);
        block.writeBlockIndex(newStart);
        block.writeBlockIndex(newStop);
    }

    public long getEntryStart() {
        this.throwExceptionIfInvalid("get entry start");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation());
        return block.readBlockIndex();
    }

    public void setEntryStop(long newStop) {
        this.throwExceptionIfInvalid("set entry stop");
        Block block = this.getFixSizeEntryBlock().getBlock();
        block.position(this.getEntryLocation() + this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex());
        block.writeBlockIndex(newStop);
    }

    public long getEntryStop() {
        this.throwExceptionIfInvalid("get entry stop");
        Block block = this.getFixSizeEntryBlock().getBlock();
        int bytesPerBlockIndex = this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
        block.position(this.getEntryLocation() + bytesPerBlockIndex);
        return block.readBlockIndex();
    }

    public CatalogBlockEntryBase(FixSizeEntryBlock<? extends CatalogBlockEntryBase> freeBlock) {
        super(freeBlock);
    }

    @Override
    public int getEntrySize() {
        return this.getFixSizeEntryBlock().getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex() * 2;
    }
}

