/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.entity;

import org.rostore.entity.Record;
import org.rostore.entity.RoStoreException;
import org.rostore.entity.media.RecordOption;

public class VersionMismatchException
extends RoStoreException {
    private static String getVersionString(long version) {
        if (version == 0L) {
            return "#undefined";
        }
        return String.valueOf(version);
    }

    private VersionMismatchException(long dataVersion, long queryVersion) {
        super("The rostore data version is " + VersionMismatchException.getVersionString(dataVersion) + ", the query data version is " + VersionMismatchException.getVersionString(queryVersion));
    }

    public static void checkAndThrow(long dataVersion, Record queryRecord) throws VersionMismatchException {
        VersionMismatchException.checkAndThrow(dataVersion, queryRecord.getVersion(), queryRecord.hasOption(RecordOption.OVERRIDE_VERSION));
    }

    public static void checkAndThrow(long dataVersion, long queryVersion, boolean overrideVersion) throws VersionMismatchException {
        if (!overrideVersion && (dataVersion != 0L ? queryVersion != 0L && dataVersion != queryVersion : queryVersion != 0L)) {
            throw new VersionMismatchException(dataVersion, queryVersion);
        }
    }
}

