/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.entity;

import java.util.EnumSet;
import java.util.Set;
import org.rostore.Utils;
import org.rostore.entity.EOLIncorrectException;
import org.rostore.entity.media.RecordOption;

public class Record {
    private long id = -1L;
    private long eol = 0L;
    private long version = 0L;
    private Set<RecordOption> options = EnumSet.noneOf(RecordOption.class);

    public Record ttlOrUnitEol(Long ttl, Long unixEol) {
        if (unixEol != null) {
            this.eol = Utils.unixEol2eol((long)unixEol);
            if (this.eol < 0L) {
                throw new EOLIncorrectException(this.eol);
            }
            return this;
        }
        if (ttl != null) {
            this.eol = Utils.ttl2eol((long)ttl);
            return this;
        }
        this.eol = 0L;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public Record id(long id) {
        this.id = id;
        return this;
    }

    public long getUnixEol() {
        return Utils.eol2unix((long)this.eol);
    }

    public long getTtl() {
        return Utils.eol2ttl((long)this.eol);
    }

    public long getEol() {
        return this.eol;
    }

    public Record ttl(long ttl) {
        this.eol = Utils.ttl2eol((long)ttl);
        return this;
    }

    public Record eol(long eol) {
        this.eol = eol;
        return this;
    }

    public void incrementVersion(int lengthBytes) {
        if (this.version != 0L) {
            ++this.version;
            this.version = Utils.trimByBytes((long)this.version, (int)lengthBytes);
            if (this.version == 0L) {
                this.version += 2L;
            }
        }
    }

    public long getVersion() {
        return this.version;
    }

    public Record version(long version) {
        this.version = version;
        return this;
    }

    public boolean hasOption(RecordOption option) {
        return this.options.contains(option);
    }

    public Record addOption(RecordOption recordOption) {
        this.options.add(recordOption);
        return this;
    }

    public Record addOptions(Set<RecordOption> recordOptions) {
        if (recordOptions != null) {
            this.options.addAll(recordOptions);
        }
        return this;
    }
}

