/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.entity;

import org.rostore.entity.MemoryAllocation;

public class MemoryAllocationState
implements MemoryAllocation {
    private long payloadSize;
    private long totalLockedSize;
    private long lockedFreeSize;

    public static MemoryAllocationState init() {
        return new MemoryAllocationState();
    }

    public static MemoryAllocationState init(long totalLockedSize, long lockedFreeSize, long payloadSize) {
        MemoryAllocationState memoryAllocationState = new MemoryAllocationState();
        memoryAllocationState.totalLockedSize = totalLockedSize;
        memoryAllocationState.lockedFreeSize = lockedFreeSize;
        memoryAllocationState.payloadSize = payloadSize;
        return memoryAllocationState;
    }

    public static MemoryAllocationState store(MemoryAllocation memoryAllocation) {
        return new MemoryAllocationState(memoryAllocation);
    }

    public synchronized void minus(MemoryAllocation memoryAllocation) {
        this.payloadSize -= memoryAllocation.getPayloadSize();
        this.totalLockedSize -= memoryAllocation.getTotalLockedSize();
        this.lockedFreeSize -= memoryAllocation.getLockedFreeSize();
    }

    public synchronized void plus(MemoryAllocation memoryAllocation) {
        this.payloadSize += memoryAllocation.getPayloadSize();
        this.totalLockedSize += memoryAllocation.getTotalLockedSize();
        this.lockedFreeSize += memoryAllocation.getLockedFreeSize();
    }

    private MemoryAllocationState() {
        this.totalLockedSize = 0L;
        this.payloadSize = 0L;
        this.lockedFreeSize = 0L;
    }

    private MemoryAllocationState(long payloadSize) {
        this.totalLockedSize = payloadSize;
        this.payloadSize = payloadSize;
        this.lockedFreeSize = 0L;
    }

    private MemoryAllocationState(MemoryAllocation memoryAllocation) {
        this.totalLockedSize = memoryAllocation.getTotalLockedSize();
        this.payloadSize = memoryAllocation.getPayloadSize();
        this.lockedFreeSize = memoryAllocation.getLockedFreeSize();
    }

    @Override
    public long getPayloadSize() {
        return this.payloadSize;
    }

    @Override
    public long getTotalLockedSize() {
        return this.totalLockedSize;
    }

    @Override
    public long getLockedFreeSize() {
        return this.lockedFreeSize;
    }

    public String toString() {
        return "MemoryAllocationState{payload=" + this.payloadSize + ", totalLocked=" + this.totalLockedSize + ", lockedFree=" + this.lockedFreeSize + "}";
    }
}

