/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client.mapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.rostore.client.ContentType;
import org.rostore.client.mapper.Mapper;

public class StringMapper
implements Mapper {
    @Override
    public <K, V> InputStream fromObject(V value, K key) {
        if (value instanceof String) {
            String str = (String)value;
            return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        }
        throw new UnsupportedOperationException("Key should be of type String");
    }

    @Override
    public <K, V> V toObject(InputStream inputStream, Class<V> valueClass, K key) {
        String ret = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
        if (valueClass.isInstance(ret)) {
            return (V)ret;
        }
        throw new UnsupportedOperationException("Key should be of type String");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.BINARY;
    }
}

