/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.rostore.client.ClientException;
import org.rostore.client.ContentType;
import org.rostore.client.mapper.Mapper;

public class JsonMapper
implements Mapper {
    private final ObjectMapper objectMapper;

    public JsonMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <K, V> InputStream fromObject(V value, K key) {
        try {
            ByteArrayOutputStream byos = new ByteArrayOutputStream();
            this.objectMapper.writeValue((OutputStream)byos, value);
            byte[] data = byos.toByteArray();
            return new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            throw new ClientException("Exception while serializing object with key=\"" + String.valueOf(key) + "\".", null, e);
        }
    }

    @Override
    public <K, V> V toObject(InputStream inputStream, Class<V> valueClass, K key) {
        try {
            return (V)this.objectMapper.readValue((Reader)new InputStreamReader(inputStream), valueClass);
        }
        catch (IOException e) {
            throw new ClientException("Exception while deserializing object with key=\"" + String.valueOf(key) + "\".", null, e);
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.JSON;
    }
}

