/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client;

public class VersionedObject<K, V> {
    private final Long version;
    private final long unixEol;
    private final K key;
    private final V value;

    public static <K, V> VersionedObject<K, V> createEternal(K key, V object, Long version) {
        return VersionedObject.create(key, object, version, null);
    }

    public static <K, V> VersionedObject<K, V> createUnversionedEternal(K key, V value) {
        return VersionedObject.create(key, value, 0L, null);
    }

    public static <K, V> VersionedObject<K, V> createNewVersionedEternal(K key, V value) {
        return VersionedObject.create(key, value, 1L, null);
    }

    public static <K, V> VersionedObject<K, V> createNewVersioned(K key, V value, Long unixEol) {
        return VersionedObject.create(key, value, 1L, unixEol);
    }

    public static <K, V> VersionedObject<K, V> create(K key, V value, Long version, Long unixEol) {
        return new VersionedObject<K, V>(key, value, version, unixEol);
    }

    public static <K, V1, V2> VersionedObject<K, V2> createDeserialized(VersionedObject<K, V1> original, V2 value) {
        return new VersionedObject<K, V2>(original.key, value, original.version, original.unixEol);
    }

    private VersionedObject(K key, V object, Long version, Long unixEol) {
        this.key = key;
        this.version = version;
        this.value = object;
        this.unixEol = unixEol == null ? 0L : unixEol;
    }

    public long getUnixEOL() {
        return this.unixEol;
    }

    public K getKey() {
        return this.key;
    }

    public Class<V> getObjectClass() {
        return this.value.getClass();
    }

    public Long getVersion() {
        return this.version == null ? 0L : this.version;
    }

    public boolean isVersioned() {
        if (this.version == null) {
            return false;
        }
        return this.version != 0L;
    }

    public V getValue() {
        return this.value;
    }

    public String toString() {
        return "VersionedObject{version=" + this.version + ", unixEol=" + this.unixEol + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "}";
    }
}

