/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.MonitoringResponseOutOfOrderStrategy;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.ResponseOutOfOrderStrategy;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.util.Timeout;
import org.rostore.client.ApiKeys;
import org.rostore.client.ClientException;
import org.rostore.client.ContentType;
import org.rostore.client.DefaultKeySerializer;
import org.rostore.client.GeneralContainer;
import org.rostore.client.KeySerializer;
import org.rostore.client.MappedContainer;
import org.rostore.client.RequestProperties;
import org.rostore.client.RoStoreClientProperties;
import org.rostore.client.VersionConflictException;
import org.rostore.client.WrappedClientException;
import org.rostore.client.mapper.JsonMapper;
import org.rostore.client.mapper.Mapper;
import org.rostore.client.mapper.NativeMapper;
import org.rostore.entity.media.RecordOption;
import org.rostore.entity.media.Version;
import org.rostore.mapper.MapperProperties;

public class RoStoreClient {
    public static final String HEADER_VERSION = "version";
    public static final String HEADER_EOL = "eol";
    public static final String HEADER_OPTIONS = "options";
    public static final String HEADER_TRACKING_ID = "trackingId";
    public static final String HEADER_API_KEY = "api-key";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String PATH__PING = "/admin/store/ping";
    public static final String PATH__SHUTDOWN = "/admin/store/shutdown";
    public static final String PATH__MAPPER_PROPERTIES = "/admin/store/mapper-properties";
    public static final String PATH__VERSION = "/admin/store/version";
    private TrustManager[] trustManagers = null;
    private final RoStoreClientProperties properties;
    private CloseableHttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final NativeMapper nativeMapper;
    private final Version version;

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public NativeMapper getNativeMapper() {
        return this.nativeMapper;
    }

    public String[] listContainers() {
        RequestProperties requestProperties = this.create("/container/list").contentType(ContentType.JSON.getMediaType());
        return this.get(requestProperties, httpResponse -> this.jsonMapper.toObject(RoStoreClient.getInputStream(httpResponse), String[].class, "container-list"));
    }

    public <K> MappedContainer<K> getMappedContainer(String name, Mapper mapper) {
        return new MappedContainer(this, name, mapper, null);
    }

    public <K> MappedContainer<K> getMappedContainer(String name, Mapper mapper, KeySerializer<K> keySerializer) {
        return new MappedContainer<K>(this, name, mapper, keySerializer);
    }

    public <K> GeneralContainer<K> getGeneralContainer(String name) {
        return this.getGeneralContainer(name, null);
    }

    public <K> GeneralContainer<K> getGeneralContainer(String name, KeySerializer<K> keySerializer) {
        return new GeneralContainer<K>(this, name, keySerializer == null ? DefaultKeySerializer.INSTANCE : keySerializer);
    }

    public ApiKeys getApiKeys() {
        return new ApiKeys(this);
    }

    public boolean ping() {
        return this.getString(this.create(PATH__PING).contentType(ContentType.JSON.getMediaType())).equals("pong");
    }

    public void shutdown() {
        this.getString(this.create(PATH__SHUTDOWN).contentType(ContentType.JSON.getMediaType()));
    }

    public RequestProperties create(String path) {
        return new RequestProperties(this.properties).path(path);
    }

    public RoStoreClientProperties getProperties() {
        return this.properties;
    }

    public RoStoreClient(TrustManager[] trustManagers, RoStoreClientProperties roStoreProperties) {
        this.trustManagers = trustManagers;
        this.properties = roStoreProperties;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper = new JsonMapper(new ObjectMapper());
        this.httpClient = this.getHttpClient();
        MapperProperties mapperProperties = this.loadMapperProperties();
        this.nativeMapper = mapperProperties != null ? new NativeMapper(mapperProperties) : null;
        this.version = this.loadVersion();
    }

    public RoStoreClient(RoStoreClientProperties roStoreProperties) {
        this(null, roStoreProperties);
    }

    private Version loadVersion() {
        try {
            RequestProperties requestProperties = this.create(PATH__VERSION).contentType(ContentType.JSON.getMediaType());
            return this.get(requestProperties, response -> this.jsonMapper.toObject(RoStoreClient.getInputStream(response), Version.class, "info"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private MapperProperties loadMapperProperties() {
        try {
            RequestProperties requestProperties = this.create(PATH__MAPPER_PROPERTIES).contentType(ContentType.JSON.getMediaType());
            return this.get(requestProperties, response -> this.jsonMapper.toObject(RoStoreClient.getInputStream(response), MapperProperties.class, "mapper-properties"));
        }
        catch (ClientException clientException) {
            return null;
        }
    }

    private void setHeaders(HttpMessage message, RequestProperties requestProperties) {
        if (requestProperties.getContentType() != null) {
            message.addHeader(HEADER_CONTENT_TYPE, (Object)requestProperties.getContentType());
        }
        if (this.properties.getApiKey() != null) {
            message.addHeader(HEADER_API_KEY, (Object)this.properties.getApiKey());
        }
        if (requestProperties.trackingId() != null) {
            message.addHeader(HEADER_TRACKING_ID, (Object)requestProperties.trackingId());
        }
        if (requestProperties.version() != null) {
            message.addHeader(HEADER_VERSION, (Object)requestProperties.version().toString());
        }
        if (requestProperties.getEOL() != null && requestProperties.getEOL() != 0L) {
            message.addHeader(HEADER_EOL, (Object)this.convertEOLToHeader(requestProperties.getEOL()));
        }
        if (!requestProperties.getRecordOptions().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (RecordOption recordOption : requestProperties.getRecordOptions()) {
                if (!sb.isEmpty()) {
                    sb.append(",");
                }
                sb.append(recordOption);
            }
            message.addHeader(HEADER_OPTIONS, (Object)sb.toString());
        }
    }

    private long convertEOLToHeader(long eol) {
        return eol;
    }

    private Long convertEOLFromHeader(Long eol) {
        return eol;
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((Duration)this.properties.getRequestTimeout())).build();
            this.httpClient = HttpClients.custom().setConnectionManager(this.getConnectionManager()).setDefaultRequestConfig(requestConfig).setUserAgent("RoStore Client 1.0").build();
        }
        return this.httpClient;
    }

    protected HttpClientConnectionManager getConnectionManager() {
        SSLContext sslContext;
        try {
            if (this.trustManagers != null) {
                try {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, this.trustManagers, null);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    sslContext = SSLContext.getDefault();
                }
            } else {
                sslContext = SSLContext.getDefault();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("Can't initialize SSL context", null, e);
        }
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, HttpsSupport.getDefaultHostnameVerifier());
        Registry registry = RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(URIScheme.HTTPS.id, (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry, (HttpConnectionFactory)ManagedHttpClientConnectionFactory.builder().responseOutOfOrderStrategy((ResponseOutOfOrderStrategy)new MonitoringResponseOutOfOrderStrategy()).build());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.of((Duration)this.properties.getConnectTimeout())).build();
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        connectionManager.setMaxTotal(this.properties.getMaxTotalConnections());
        connectionManager.setDefaultMaxPerRoute(this.properties.getMaxConnectionsPerRoute());
        return connectionManager;
    }

    private URI getUri(String path) {
        return URI.create(this.properties.getBaseUrl() + path);
    }

    public <T> T get(RequestProperties requestProperties, Function<CloseableHttpResponse, T> deserializer) {
        HttpGet get = new HttpGet(this.getUri(requestProperties.getPath()));
        return this.standardRequest((HttpUriRequestBase)get, requestProperties, null, deserializer);
    }

    public boolean delete(RequestProperties requestProperties) {
        HttpDelete delete = new HttpDelete(this.getUri(requestProperties.getPath()));
        return this.standardRequest((HttpUriRequestBase)delete, requestProperties, null, response -> {
            if (response.getCode() >= 200 && response.getCode() < 300) {
                return true;
            }
            this.throwClientException(delete.getMethod(), requestProperties, (CloseableHttpResponse)response);
            return false;
        });
    }

    public byte[] getBytes(RequestProperties requestProperties) {
        return this.get(requestProperties, response -> {
            try {
                return response.getEntity().getContent().readAllBytes();
            }
            catch (IOException e) {
                throw new ClientException("Call to \"" + requestProperties.getPath() + "\" has failed.", requestProperties, e);
            }
        });
    }

    public String getString(RequestProperties requestProperties) {
        return new String(this.getBytes(requestProperties), StandardCharsets.UTF_8);
    }

    public <T> T post(RequestProperties requestProperties, InputStream data, Function<CloseableHttpResponse, T> deserializer) {
        HttpPost post = new HttpPost(this.getUri(requestProperties.getPath()));
        return this.standardRequest((HttpUriRequestBase)post, requestProperties, data, deserializer);
    }

    public <T> T put(RequestProperties requestProperties, InputStream data, Function<CloseableHttpResponse, T> deserializer) {
        HttpPut put = new HttpPut(this.getUri(requestProperties.getPath()));
        return this.standardRequest((HttpUriRequestBase)put, requestProperties, data, deserializer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T standardRequest(HttpUriRequestBase requestBase, RequestProperties requestProperties, InputStream data, Function<CloseableHttpResponse, T> deserializer) {
        this.setHeaders((HttpMessage)requestBase, requestProperties);
        if (data != null) {
            requestBase.setEntity((HttpEntity)new InputStreamEntity(data, org.apache.hc.core5.http.ContentType.APPLICATION_OCTET_STREAM));
        }
        try (CloseableHttpResponse response = this.getHttpClient().execute((ClassicHttpRequest)requestBase);){
            if (response.getCode() >= 200 && response.getCode() < 300) {
                CloseableHttpResponse closeableHttpResponse = deserializer.apply(response);
                return (T)closeableHttpResponse;
            }
            if (response.getCode() == 409) {
                throw new VersionConflictException("Wrong version", requestProperties);
            }
            this.throwClientException(requestBase.getMethod(), requestProperties, response);
            T t = null;
            return t;
        }
        catch (Exception e) {
            this.wrapException(requestBase.getMethod(), requestProperties, e);
            return null;
        }
    }

    private static String getHeader(CloseableHttpResponse response, String headerName) {
        try {
            Header header = response.getHeader(headerName);
            if (header != null) {
                return header.getValue();
            }
            return null;
        }
        catch (ProtocolException e) {
            throw new WrappedClientException("Can't get header \"" + headerName + "\"", (Exception)((Object)e));
        }
    }

    private void throwClientException(String operation, RequestProperties requestProperties, CloseableHttpResponse response) {
        String contentType = RoStoreClient.getHeader(response, HEADER_CONTENT_TYPE);
        String serverMessage = null;
        if (ContentType.JSON.getMediaType().equals(contentType)) {
            try {
                serverMessage = this.jsonMapper.toObject((InputStream)response.getEntity().getContent(), ErrorRepr.class, "-").message;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String trackingId = RoStoreClient.getTrackingIdHeader(response);
        throw new ClientException("Can't execute \"" + operation + "\" on \"" + requestProperties.getPath() + "\". Server responded with status=\"" + response.getCode() + "\", error ref=\"" + trackingId + "\"", requestProperties, trackingId, serverMessage);
    }

    private void wrapException(String operation, RequestProperties requestProperties, Exception exception) {
        if (exception instanceof ClientException) {
            throw (ClientException)exception;
        }
        if (exception instanceof VersionConflictException) {
            throw (VersionConflictException)exception;
        }
        if (exception instanceof WrappedClientException) {
            if (exception.getCause() != null) {
                throw new ClientException("Exception while executing \"" + operation + "\" on \"" + requestProperties.getPath() + "\": " + exception.getMessage(), requestProperties, exception.getCause());
            }
            throw new ClientException("Exception while executing \"" + operation + "\" on \"" + requestProperties.getPath() + "\": " + exception.getMessage(), requestProperties);
        }
        if (exception instanceof SSLHandshakeException) {
            throw new ClientException("SSL Exception while executing \"" + operation + "\" on \"" + requestProperties.getPath() + "\".", requestProperties, exception);
        }
        throw new ClientException("Exception while executing \"" + operation + "\" on \"" + requestProperties.getPath() + "\".", requestProperties, exception);
    }

    private static String getTrackingIdHeader(CloseableHttpResponse response) {
        return RoStoreClient.getHeader(response, HEADER_TRACKING_ID);
    }

    public static Long getVersionHeader(CloseableHttpResponse response) {
        String version = RoStoreClient.getHeader(response, HEADER_VERSION);
        if (version != null) {
            return Long.parseLong(version);
        }
        return null;
    }

    public Long getEOLHeader(CloseableHttpResponse response) {
        Long eol;
        String eolHeader = RoStoreClient.getHeader(response, HEADER_EOL);
        if (eolHeader != null && (eol = Long.valueOf(Long.parseLong(eolHeader))) != 0L) {
            return this.convertEOLFromHeader(eol);
        }
        return null;
    }

    public static InputStream getInputStream(CloseableHttpResponse response) {
        try {
            return response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new WrappedClientException("Can't read body of the response", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ErrorRepr {
        String message;

        private ErrorRepr() {
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

