/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.function.Function;
import org.rostore.client.GeneralContainer;
import org.rostore.client.KeyExpirationUpdateFunction;
import org.rostore.client.KeySerializer;
import org.rostore.client.RoStoreClient;
import org.rostore.client.VersionedObject;
import org.rostore.client.mapper.Mapper;
import org.rostore.entity.media.ContainerMeta;
import org.rostore.entity.media.RecordOption;

public class MappedContainer<K> {
    private final GeneralContainer<K> generalContainer;
    private final Mapper mapper;

    protected MappedContainer(RoStoreClient roStoreClient, String name, Mapper mapper, KeySerializer<K> keySerializer) {
        this.mapper = mapper;
        this.generalContainer = roStoreClient.getGeneralContainer(name, keySerializer);
    }

    public void remove() {
        this.generalContainer.remove();
    }

    public void create(ContainerMeta containerMeta) {
        this.generalContainer.create(containerMeta);
    }

    public <V> VersionedObject<K, V> update(VersionedObject<K, V> original, Function<V, V> updateFunction, KeyExpirationUpdateFunction keyExpirationUpdateFunction) {
        return this.generalContainer.update(original, keyExpirationUpdateFunction, updateFunction, v -> this.mapper.fromObject(v, original.getKey()), is -> this.mapper.toObject((InputStream)is, original.getObjectClass(), original.getKey()));
    }

    public <V> VersionedObject<K, V> update(VersionedObject<K, V> original, Function<V, V> updateFunction) {
        return this.update(original, updateFunction, null);
    }

    public <V> VersionedObject<K, V> post(VersionedObject<K, V> versionedObject) {
        return this.post(versionedObject, null);
    }

    public <V> VersionedObject<K, V> post(VersionedObject<K, V> versionedObject, EnumSet<RecordOption> options) {
        return this.generalContainer.post(versionedObject, options, t -> this.mapper.fromObject(versionedObject.getValue(), versionedObject.getKey()));
    }

    public boolean removeKey(K key) {
        return this.removeKey(key, 0L, EnumSet.noneOf(RecordOption.class));
    }

    public boolean removeKey(K key, long version) {
        return this.generalContainer.removeKey(key, version, EnumSet.noneOf(RecordOption.class));
    }

    public boolean removeKey(K key, long version, EnumSet<RecordOption> options) {
        return this.generalContainer.removeKey(key, version, options);
    }

    public String getName() {
        return this.generalContainer.getName();
    }

    public <V> VersionedObject<K, V> get(K key, Class<V> valueClass) {
        return this.generalContainer.get(key, (InputStream is) -> this.mapper.toObject((InputStream)is, valueClass, key));
    }
}

