/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.rostore.client.ClientException;
import org.rostore.client.ContentType;
import org.rostore.client.KeyExpirationUpdateFunction;
import org.rostore.client.KeySerializer;
import org.rostore.client.RequestProperties;
import org.rostore.client.RoStoreClient;
import org.rostore.client.StringKeyList;
import org.rostore.client.VersionConflictException;
import org.rostore.client.VersionedObject;
import org.rostore.entity.media.ContainerMeta;
import org.rostore.entity.media.ContainerMetaCompatibility;
import org.rostore.entity.media.RecordOption;

public class GeneralContainer<K> {
    private static final Logger logger = Logger.getLogger(GeneralContainer.class.getName());
    private final String name;
    private final KeySerializer<K> keySerializer;
    private final RoStoreClient roStoreClient;

    protected GeneralContainer(RoStoreClient roStoreClient, String name, KeySerializer<K> keySerializer) {
        this.roStoreClient = roStoreClient;
        this.name = name;
        this.keySerializer = keySerializer;
    }

    public void remove() {
        RequestProperties requestProperties = this.roStoreClient.create("/admin/container/" + this.name);
        this.roStoreClient.delete(requestProperties);
    }

    public void create(ContainerMeta containerMeta) {
        RequestProperties requestProperties = this.roStoreClient.create("/admin/container/" + this.name).contentType(ContentType.JSON.getMediaType());
        InputStream inputStream = this.roStoreClient.getJsonMapper().fromObject(containerMeta, "create-container");
        this.roStoreClient.post(requestProperties, inputStream, (CloseableHttpResponse response) -> null);
    }

    public ContainerMeta getMeta() {
        RequestProperties requestProperties = this.roStoreClient.create("/admin/container/" + this.name + "/meta").contentType(ContentType.JSON.getMediaType());
        ContainerMetaCompatibility containerMetaCompatibility = this.roStoreClient.get(requestProperties, (CloseableHttpResponse response) -> this.roStoreClient.getJsonMapper().toObject(RoStoreClient.getInputStream(response), ContainerMetaCompatibility.class, "get-container-meta"));
        ContainerMeta containerMeta = new ContainerMeta();
        containerMeta.setCreationTime(containerMetaCompatibility.getCreationTime());
        containerMeta.setMaxSize(containerMetaCompatibility.getMaxSize());
        containerMeta.setMaxTTL(containerMetaCompatibility.getMaxTTL());
        if (containerMetaCompatibility.getShardNumber() != 0) {
            containerMeta.setShardNumber(containerMetaCompatibility.getShardNumber());
        } else {
            containerMeta.setShardNumber(containerMetaCompatibility.getSegmentNumber());
        }
        return containerMeta;
    }

    public StringKeyList listKeys(String startWithKey, String continuationKey) {
        StringBuilder builder = new StringBuilder("/container/");
        builder.append(this.name).append("/keys");
        String query = "?";
        if (startWithKey != null) {
            builder.append(query).append("start-with-key=");
            builder.append(startWithKey);
            query = "&";
        }
        if (continuationKey != null) {
            builder.append(query).append("continuation-key=");
            builder.append(continuationKey);
        }
        String path = builder.toString();
        RequestProperties requestProperties = this.roStoreClient.create(path).contentType(ContentType.JSON.getMediaType());
        return this.roStoreClient.get(requestProperties, (CloseableHttpResponse httpResponse) -> this.roStoreClient.getJsonMapper().toObject(RoStoreClient.getInputStream(httpResponse), StringKeyList.class, "key-list"));
    }

    public <V> VersionedObject<K, V> update(VersionedObject<K, V> original, KeyExpirationUpdateFunction keyExpirationUpdateFunction, Function<V, V> updateFunction, Function<V, InputStream> serializer, Function<InputStream, V> deserializer) {
        VersionedObject<K, V> current = original;
        VersionConflictException baseException = null;
        for (int i = 0; i < this.roStoreClient.getProperties().getUpdateRetries(); ++i) {
            try {
                V updatedObject = updateFunction.apply(current.getValue());
                VersionedObject<K, V> updated = VersionedObject.create(current.getKey(), updatedObject, current.getVersion(), keyExpirationUpdateFunction == null ? original.getUnixEOL() : keyExpirationUpdateFunction.unixEol(current));
                return this.post(updated, serializer);
            }
            catch (VersionConflictException conflict) {
                baseException = conflict;
                logger.fine("Conflict while posting \"" + String.valueOf(current.getKey()) + "\", message: " + conflict.getMessage());
                if (i == this.roStoreClient.getProperties().getUpdateRetries() - 1) continue;
                current = this.get(current.getKey(), deserializer);
                try {
                    Thread.sleep((long)((double)this.roStoreClient.getProperties().getUpdateTimeoutMax().toMillis() * Math.random()));
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        throw new ClientException("The update for key \"" + String.valueOf(original.getKey()) + "\" has failed.", baseException.getRequestProperties(), baseException);
    }

    public <V> VersionedObject<K, V> update(VersionedObject<K, V> original, Function<V, V> updateFunction, Function<V, InputStream> serializer, Function<InputStream, V> deserializer) {
        return this.update(original, null, updateFunction, serializer, deserializer);
    }

    public String getKeyPath(K key) {
        try {
            String encodedKey = URLEncoder.encode(this.keySerializer.toString(key), StandardCharsets.UTF_8.toString());
            return "/container/" + this.name + "/key/" + encodedKey;
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Can't encode key \"" + String.valueOf(key) + "\"", null, e);
        }
    }

    public Boolean removeKey(K key, long version, EnumSet<RecordOption> options) {
        RequestProperties rp = this.roStoreClient.create(this.getKeyPath(key));
        if (version != 0L) {
            rp.version(version);
        }
        rp.options(options);
        return this.roStoreClient.delete(rp);
    }

    public VersionedObject<K, InputStream> post(VersionedObject<K, InputStream> versionedObject, EnumSet<RecordOption> options) {
        return this.post(versionedObject, options, is -> is);
    }

    public VersionedObject<K, InputStream> post(VersionedObject<K, InputStream> versionedObject) {
        return this.post(versionedObject, EnumSet.noneOf(RecordOption.class));
    }

    public <V> VersionedObject<K, V> post(VersionedObject<K, V> versionedObject, Function<V, InputStream> serializer) {
        return this.post(versionedObject, EnumSet.noneOf(RecordOption.class), serializer);
    }

    public <V> VersionedObject<K, V> post(VersionedObject<K, V> versionedObject, EnumSet<RecordOption> options, Function<V, InputStream> serializer) {
        RequestProperties rp = this.roStoreClient.create(this.getKeyPath(versionedObject.getKey())).version(versionedObject.getVersion()).unixEol(versionedObject.getUnixEOL()).options(options).contentType(ContentType.BINARY.getMediaType());
        return this.roStoreClient.post(rp, serializer.apply(versionedObject.getValue()), (CloseableHttpResponse response) -> {
            Long version = RoStoreClient.getVersionHeader(response);
            Long unixEOL = this.roStoreClient.getEOLHeader((CloseableHttpResponse)response);
            return VersionedObject.create(versionedObject.getKey(), versionedObject.getValue(), version, unixEOL);
        });
    }

    public <V> VersionedObject<K, V> get(K key, Function<InputStream, V> deserializer) {
        return this.get(key, EnumSet.noneOf(RecordOption.class), deserializer);
    }

    public <V> VersionedObject<K, V> get(K key, EnumSet<RecordOption> options, Function<InputStream, V> deserializer) {
        return this.getWrapped(key, options, versionedInputStream -> {
            Object v = deserializer.apply((InputStream)versionedInputStream.getValue());
            return VersionedObject.createDeserialized(versionedInputStream, v);
        });
    }

    public <V> VersionedObject<K, V> getWrapped(K key, EnumSet<RecordOption> options, Function<VersionedObject<K, InputStream>, VersionedObject<K, V>> transformation) {
        RequestProperties rp = this.roStoreClient.create(this.getKeyPath(key));
        rp.contentType(ContentType.BINARY.getMediaType());
        rp.options(options);
        return this.roStoreClient.get(rp, (CloseableHttpResponse response) -> {
            Long version = RoStoreClient.getVersionHeader(response);
            Long unixEOL = this.roStoreClient.getEOLHeader((CloseableHttpResponse)response);
            VersionedObject<Object, InputStream> versionedObject = VersionedObject.create(key, RoStoreClient.getInputStream(response), version, unixEOL);
            return (VersionedObject)transformation.apply(versionedObject);
        });
    }

    public String getName() {
        return this.name;
    }
}

