/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.client;

import java.io.InputStream;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.rostore.client.ContentType;
import org.rostore.client.RequestProperties;
import org.rostore.client.RoStoreClient;
import org.rostore.client.StringKeyList;
import org.rostore.client.VersionedObject;
import org.rostore.entity.apikey.ApiKeyDefinition;
import org.rostore.entity.apikey.ApiKeyPermissions;

public class ApiKeys {
    private final RoStoreClient roStoreClient;

    protected ApiKeys(RoStoreClient roStoreClient) {
        this.roStoreClient = roStoreClient;
    }

    public StringKeyList listApiKeys(String continuationKey) {
        StringBuilder builder = new StringBuilder("/admin/api-key/list");
        if (continuationKey != null) {
            builder.append("?").append("start-api-key=");
            builder.append(continuationKey);
        }
        String path = builder.toString();
        RequestProperties requestProperties = this.roStoreClient.create(path).contentType(ContentType.JSON.getMediaType());
        return this.roStoreClient.get(requestProperties, httpResponse -> this.roStoreClient.getJsonMapper().toObject(RoStoreClient.getInputStream(httpResponse), StringKeyList.class, "api-key-list"));
    }

    public VersionedObject<String, ApiKeyPermissions> post(VersionedObject<String, ApiKeyPermissions> apiKeyPermissions) {
        RequestProperties rp = this.roStoreClient.create("/admin/api-key").unixEol(apiKeyPermissions.getUnixEOL()).contentType(ContentType.JSON.getMediaType());
        InputStream inputStream = this.roStoreClient.getJsonMapper().fromObject(apiKeyPermissions.getValue(), "api-key");
        return this.roStoreClient.post(rp, inputStream, response -> this.toObject((CloseableHttpResponse)response));
    }

    public VersionedObject<String, ApiKeyPermissions> get(String key) {
        RequestProperties rp = this.roStoreClient.create("/admin/api-key/" + key).contentType(ContentType.JSON.getMediaType());
        return this.roStoreClient.get(rp, response -> this.toObject((CloseableHttpResponse)response));
    }

    public VersionedObject<String, ApiKeyPermissions> put(VersionedObject<String, ApiKeyPermissions> apiKeyPermissions) {
        RequestProperties rp = this.roStoreClient.create("/admin/api-key/" + apiKeyPermissions.getKey()).unixEol(apiKeyPermissions.getUnixEOL()).contentType(ContentType.JSON.getMediaType());
        InputStream inputStream = this.roStoreClient.getJsonMapper().fromObject(apiKeyPermissions.getValue(), "api-key");
        return this.roStoreClient.put(rp, inputStream, response -> this.toObject((CloseableHttpResponse)response));
    }

    private VersionedObject<String, ApiKeyPermissions> toObject(CloseableHttpResponse response) {
        Long unixEol = this.roStoreClient.getEOLHeader(response);
        ApiKeyDefinition apiKeyDefinition = this.roStoreClient.getJsonMapper().toObject(RoStoreClient.getInputStream(response), ApiKeyDefinition.class, "api-key");
        return VersionedObject.create(apiKeyDefinition.getKey(), apiKeyDefinition.getApiKeyPermissions(), null, unixEol);
    }
}

