/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.container.async.OperationExecutionException;
import org.rostore.v2.container.async.OperationTarget;
import org.rostore.v2.container.async.OperationType;

public class Operation<R>
implements Future<R> {
    private final int sessionId;
    private final OperationType operationType;
    private final OperationTarget operationTarget;
    private final Supplier<R> function;
    private R result;
    private Exception exception;
    private final CountDownLatch countDownLatch;
    private boolean done;
    private final long valueId;

    public String toString() {
        return "Operation " + String.valueOf((Object)this.operationTarget) + " " + String.valueOf((Object)this.operationType) + (String)(this.valueId != -1L ? " valueId=" + this.valueId : "");
    }

    public long getValueId() {
        if (this.valueId == -1L) {
            throw new RoStoreException("Operation is not a value operation!");
        }
        return this.valueId;
    }

    public static <R> Operation<R> value(int sessionId, OperationType operationType, long valueId, Supplier<R> function) {
        return new Operation<R>(sessionId, OperationTarget.VALUE, operationType, valueId, false, function);
    }

    public static Operation autonomousValue(int sessionId, OperationType operationType, long valueId, Runnable runnable) {
        return new Operation<Boolean>(sessionId, OperationTarget.VALUE, operationType, valueId, true, () -> {
            runnable.run();
            return true;
        });
    }

    public static <R> Operation<R> key(int sessionId, OperationType operationType, Supplier<R> function) {
        return new Operation<R>(sessionId, OperationTarget.KEY, operationType, -1L, false, function);
    }

    public static Operation autonomousKey(int sessionId, OperationType operationType, Runnable runnable) {
        return new Operation<Boolean>(sessionId, OperationTarget.KEY, operationType, -1L, true, () -> {
            runnable.run();
            return true;
        });
    }

    private Operation(int sessionId, OperationTarget target, OperationType operationType, long valueId, boolean autonomous, Supplier<R> function) {
        this.sessionId = sessionId;
        this.operationType = operationType;
        this.function = function;
        this.countDownLatch = autonomous ? null : new CountDownLatch(1);
        this.done = false;
        this.valueId = valueId;
        this.operationTarget = target;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public OperationType getType() {
        return this.operationType;
    }

    public OperationTarget getTarget() {
        return this.operationTarget;
    }

    public void rethrowExceptionIfOccurred() throws ExecutionException {
        if (this.exception != null) {
            throw new OperationExecutionException(this.exception);
        }
    }

    public void execute() {
        try {
            this.result = this.function.get();
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public void done() {
        this.done = true;
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public boolean isAutonomous() {
        return this.countDownLatch == null;
    }

    public void cancel(R result) {
        this.result = result;
        this.done = true;
        this.countDownLatch.countDown();
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        this.countDownLatch.await();
        this.rethrowExceptionIfOccurred();
        return this.result;
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.countDownLatch.await(timeout, unit)) {
            throw new TimeoutException("Timeout elapsed after waiting for " + timeout + String.valueOf((Object)unit));
        }
        this.rethrowExceptionIfOccurred();
        return this.result;
    }
}

