/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container.async;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.container.ContainerShard;
import org.rostore.v2.container.ContainerShardKeyOperations;
import org.rostore.v2.container.async.AsyncContainer;
import org.rostore.v2.container.async.AsyncContainers;
import org.rostore.v2.container.async.ContainerShardCleanupManager;
import org.rostore.v2.container.async.InterruptedShardOperation;
import org.rostore.v2.container.async.KeyExecutionState;
import org.rostore.v2.container.async.Operation;
import org.rostore.v2.container.async.OperationTarget;
import org.rostore.v2.container.async.OperationType;

public class ContainerShardExecutor {
    private static final Logger logger = Logger.getLogger(ContainerShardExecutor.class.getName());
    private final AsyncContainer asyncContainer;
    private final ContainerShardCleanupManager cleanupManager;
    private final ContainerShard shard;
    private KeyExecutionState keyExecutionState;
    private int keyReadCount;
    private int valueWriteCount;
    private boolean shutdown;
    private CountDownLatch shutdownLatch;
    private final Queue<Operation> keyOperations = new LinkedList<Operation>();
    private final Map<Long, Operation> waitingDeleteValueOperations = new HashMap<Long, Operation>();
    private final Set<Long> runningDeleteValueOperations = new HashSet<Long>();
    private final Map<Long, Integer> readValueOperations = new HashMap<Long, Integer>();

    public ContainerShard getShard() {
        return this.shard;
    }

    public AsyncContainers getAsyncContainers() {
        return this.asyncContainer.getAsyncContainers();
    }

    protected ContainerShardExecutor(AsyncContainer asyncContainer, ContainerShard shard) {
        this.asyncContainer = asyncContainer;
        this.shard = shard;
        this.keyExecutionState = KeyExecutionState.IDLE;
        this.shutdown = false;
        this.shutdownLatch = new CountDownLatch(1);
        this.keyReadCount = 0;
        this.valueWriteCount = 0;
        this.cleanupManager = new ContainerShardCleanupManager(this);
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.shutdownIfHasTo();
    }

    public synchronized boolean isIdle() {
        return this.keyExecutionState == KeyExecutionState.IDLE && this.keyOperations.isEmpty() && this.waitingDeleteValueOperations.isEmpty() && this.runningDeleteValueOperations.isEmpty() && this.readValueOperations.isEmpty() && this.valueWriteCount == 0 && !this.cleanupManager.isQueued();
    }

    public <R> Future<R> executeKey(int sessionId, OperationType opsType, boolean failInShutdown, Function<ContainerShardKeyOperations, R> opsConsumer) {
        return this.execute(Operation.key(sessionId, opsType, () -> this.shard.keyFunction(opsConsumer)), failInShutdown);
    }

    public <R> Future<R> executeAutonomousValue(int sessionId, OperationType opsType, long valueId, boolean failInShutdown, Runnable valueOp) {
        return this.execute(Operation.autonomousValue(sessionId, opsType, valueId, valueOp), failInShutdown);
    }

    public <R> Future<R> executeValue(int sessionId, OperationType opsType, long valueId, boolean failInShutdown, Supplier<R> supplier) {
        return this.execute(Operation.value(sessionId, opsType, valueId, supplier), failInShutdown);
    }

    public synchronized <R> Future<R> execute(Operation<R> operation, boolean failInShutdown) {
        if (failInShutdown && this.shutdown) {
            return InterruptedShardOperation.INTERRUPTED_SHARD_OPERATION;
        }
        if (operation.getTarget() == OperationTarget.KEY) {
            this.keyOperations.offer(operation);
            this.processKeyOperations();
            return operation;
        }
        switch (operation.getType()) {
            case READ: {
                if (this.runningDeleteValueOperations.contains(operation.getValueId()) || this.waitingDeleteValueOperations.containsKey(operation.getValueId())) {
                    operation.cancel(null);
                    return operation;
                }
                this.submit(operation);
                return operation;
            }
            case WRITE: {
                this.submit(operation);
                return operation;
            }
            case DELETE: {
                if (this.waitingDeleteValueOperations.containsKey(operation.getValueId()) || this.runningDeleteValueOperations.contains(operation.getValueId())) {
                    throw new RoStoreException("Secondary delete operation!");
                }
                if (this.readValueOperations.containsKey(operation.getValueId())) {
                    this.waitingDeleteValueOperations.put(operation.getValueId(), operation);
                    return operation;
                }
                this.submit(operation);
                return operation;
            }
        }
        throw new RoStoreException("Unknown operation mode");
    }

    private boolean processKeyOperations() {
        if (this.keyOperations.isEmpty()) {
            return false;
        }
        switch (this.keyExecutionState) {
            case IDLE: {
                this.submit(this.keyOperations.poll());
                return true;
            }
            case EXCLUSIVE: {
                return false;
            }
            case MULTIPLE: {
                if (this.keyOperations.peek().getType() == OperationType.READ) {
                    this.submit(this.keyOperations.poll());
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void processAllKeyOperations() {
        while (this.processKeyOperations()) {
        }
    }

    private synchronized void done(Operation operation) {
        operation.done();
        if (operation.isAutonomous() && operation.getException() != null) {
            logger.log(Level.WARNING, "Exception has been detected in the autonomous operation " + String.valueOf(operation), operation.getException());
        }
        if (OperationTarget.KEY.equals((Object)operation.getTarget())) {
            switch (operation.getType()) {
                case READ: {
                    --this.keyReadCount;
                    if (this.keyReadCount != 0) break;
                    this.keyExecutionState = KeyExecutionState.IDLE;
                    break;
                }
                case WRITE: 
                case DELETE: {
                    this.keyExecutionState = KeyExecutionState.IDLE;
                }
            }
            this.processAllKeyOperations();
        } else {
            switch (operation.getType()) {
                case READ: {
                    Operation pendingDeleteOperation;
                    if (!this.decrementReadValueCounter(operation) || (pendingDeleteOperation = this.waitingDeleteValueOperations.remove(operation.getValueId())) == null) break;
                    this.submit(pendingDeleteOperation);
                    break;
                }
                case DELETE: {
                    this.runningDeleteValueOperations.remove(operation.getValueId());
                    break;
                }
                case WRITE: {
                    --this.valueWriteCount;
                }
            }
        }
        this.shutdownIfHasTo();
    }

    public void shutdownIfHasTo() {
        if (this.isIdle()) {
            if (this.shutdown && this.shutdownLatch.getCount() != 0L) {
                this.shutdownLatch.countDown();
            }
            this.asyncContainer.notifyIdle(this);
        }
        this.notify();
    }

    public void shutdownAndWait() {
        this.shutdown();
        this.waitForShutdown();
    }

    public void waitForShutdown() {
        if (!this.shutdown) {
            throw new RoStoreException("Trying to wait for shutdown on active shard.");
        }
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RoStoreException("Interrupted while waiting for shutdown of container shard", (Throwable)e);
        }
    }

    private void submit(Operation operation) {
        if (OperationTarget.KEY.equals((Object)operation.getTarget())) {
            switch (operation.getType()) {
                case WRITE: 
                case DELETE: {
                    this.keyExecutionState = KeyExecutionState.EXCLUSIVE;
                    break;
                }
                case READ: {
                    this.keyExecutionState = KeyExecutionState.MULTIPLE;
                    ++this.keyReadCount;
                }
            }
        } else {
            switch (operation.getType()) {
                case DELETE: {
                    this.runningDeleteValueOperations.add(operation.getValueId());
                    break;
                }
                case READ: {
                    this.incrementReadValueCounter(operation);
                    break;
                }
                case WRITE: {
                    ++this.valueWriteCount;
                }
            }
        }
        this.asyncContainer.getAsyncContainers().getExecutorService().submit(() -> {
            try {
                operation.execute();
                if (!this.shutdown) {
                    this.cleanupManager.scheduleCleanup();
                    this.asyncContainer.getAsyncContainers().getCleanupManager().scheduleCleanup();
                }
            }
            catch (Exception e) {
                operation.setException(e);
            }
            finally {
                this.done(operation);
            }
        });
    }

    private void incrementReadValueCounter(Operation operation) {
        Integer counter = this.readValueOperations.get(operation.getValueId());
        if (counter == null) {
            counter = 1;
        } else {
            Integer n = counter;
            counter = counter + 1;
        }
        this.readValueOperations.put(operation.getValueId(), counter);
    }

    private boolean decrementReadValueCounter(Operation operation) {
        Integer counter = this.readValueOperations.get(operation.getValueId());
        if (counter == 1) {
            this.readValueOperations.remove(operation.getValueId());
            return true;
        }
        Integer n = counter;
        counter = counter - 1;
        this.readValueOperations.put(operation.getValueId(), counter);
        return false;
    }
}

