/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container.async;

import org.rostore.v2.container.ContainerShardKeyOperations;
import org.rostore.v2.container.async.CleanupManager;
import org.rostore.v2.container.async.ContainerShardExecutor;
import org.rostore.v2.container.async.OperationType;

public class ContainerShardCleanupManager
extends CleanupManager {
    private int nextRunBlockIndex = 0;
    private final int maxNumberOfCleans;
    private ContainerShardExecutor containerShardExecutor;

    public ContainerShardCleanupManager(ContainerShardExecutor containerShardExecutor) {
        super(containerShardExecutor.getAsyncContainers().getExecutorService(), containerShardExecutor.getAsyncContainers().getContainerListHeader().getContainerListProperties().getCleanupIntervalMillis());
        this.maxNumberOfCleans = containerShardExecutor.getAsyncContainers().getContainerListHeader().getContainerListProperties().getMaxCleanupsPerCycle();
        this.containerShardExecutor = containerShardExecutor;
    }

    @Override
    protected void execute() {
        this.containerShardExecutor.executeKey(0, OperationType.WRITE, true, this::queue);
    }

    @Override
    protected void finalized() {
        this.containerShardExecutor.shutdownIfHasTo();
    }

    public boolean queue(ContainerShardKeyOperations ops) {
        long id;
        if (this.nextRunBlockIndex >= ops.getBlockSequence().length()) {
            this.nextRunBlockIndex = 0;
        }
        boolean ret = false;
        int cleanNumber = 0;
        while ((id = ops.removeKeyIfExpired(this.nextRunBlockIndex)) != -1L) {
            this.containerShardExecutor.executeAutonomousValue(0, OperationType.DELETE, id, false, () -> this.containerShardExecutor.getShard().removeValue(id));
            if (++cleanNumber <= this.maxNumberOfCleans) continue;
            ret = true;
            break;
        }
        if (!ret) {
            ++this.nextRunBlockIndex;
        }
        return ret;
    }
}

